/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindparam;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgExecute
extends TbMsg {
    public byte[] ppid = new byte[8];
    public int flag;
    public int prefetchSize;
    public int paramInfoArrayCnt;
    public TbBindparam[] paramInfo;

    public TbMsgExecute(int autoCommit) {
        this.msgType = 5;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] ppid, int flag, int prefetchSize, int paramInfoArrayCnt, TbBindparam[] paramInfo) {
        this.ppid = ppid;
        this.flag = flag;
        this.prefetchSize = prefetchSize;
        this.paramInfoArrayCnt = paramInfoArrayCnt;
        this.paramInfo = paramInfo;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeBytes(this.ppid);
        writer.writeInt(this.flag, 4);
        writer.writeInt(this.prefetchSize, 4);
        writer.writeInt(this.paramInfoArrayCnt, 4);
        if (this.paramInfo != null) {
            for (int i = 0; i < this.paramInfoArrayCnt; ++i) {
                this.paramInfo[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        reader.readBytes(this.ppid, 0, 8);
        this.flag = reader.readInt32();
        this.prefetchSize = reader.readInt32();
        int paramInfoLen = reader.readInt32();
        if (paramInfoLen > 0) {
            this.paramInfo = new TbBindparam[paramInfoLen];
            for (int i = 0; i < paramInfoLen; ++i) {
                this.paramInfo[i] = new TbBindparam();
                this.paramInfo[i].deserialize(reader);
            }
        } else {
            this.paramInfo = null;
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgExecute msg = (TbMsgExecute)obj;
        if (this.ppid == null && msg.ppid != null || this.ppid != null && msg.ppid == null) {
            return false;
        }
        if (this.ppid != null && msg.ppid != null) {
            if (this.ppid.length != msg.ppid.length) {
                return false;
            }
            for (i = 0; i < msg.ppid.length; ++i) {
                if (this.ppid[i] == msg.ppid[i]) continue;
                return false;
            }
        }
        if (this.flag != msg.flag) {
            return false;
        }
        if (this.prefetchSize != msg.prefetchSize) {
            return false;
        }
        if (this.paramInfo == null && msg.paramInfo != null || this.paramInfo != null && msg.paramInfo == null) {
            return false;
        }
        if (this.paramInfo != null && msg.paramInfo != null) {
            if (this.paramInfo.length != msg.paramInfo.length) {
                return false;
            }
            for (i = 0; i < msg.paramInfo.length; ++i) {
                if (this.paramInfo[i].equals(msg.paramInfo[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgExecute]/");
        str.append("ppid=");
        if (this.ppid != null) {
            for (i = 0; i < this.ppid.length; ++i) {
                str.append(this.ppid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("flag=");
        str.append(this.flag);
        str.append("/");
        str.append("prefetchSize=");
        str.append(this.prefetchSize);
        str.append("/");
        str.append("paramInfo={\n");
        if (this.paramInfo != null) {
            for (i = 0; i < this.paramInfo.length; ++i) {
                str.append("  paramInfo[" + i + "]=" + this.paramInfo[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

