/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLobInstr
extends TbMsg {
    public int offsetHigh;
    public int offsetLow;
    public byte[] slobLoc;
    public int slobLocLen;
    public String pattern;

    public TbMsgLobInstr(int autoCommit) {
        this.msgType = 39;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int offsetHigh, int offsetLow, byte[] slobLoc, int slobLocLen, String pattern) {
        this.offsetHigh = offsetHigh;
        this.offsetLow = offsetLow;
        this.slobLoc = slobLoc;
        this.slobLocLen = slobLocLen;
        this.pattern = pattern;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.offsetHigh, 4);
        writer.writeInt(this.offsetLow, 4);
        if (this.slobLocLen != 0) {
            writer.writeInt(this.slobLocLen, 4);
            writer.writePadBytes(this.slobLoc, 0, this.slobLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        if (this.pattern != null) {
            writer.writeLenAndDBEncodedPadString(this.pattern);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.offsetHigh = reader.readInt32();
        this.offsetLow = reader.readInt32();
        int slobLocLen = reader.readInt32();
        if (slobLocLen != 0) {
            this.slobLoc = new byte[slobLocLen];
            reader.readPadBytes(this.slobLoc, 0, slobLocLen);
        } else {
            reader.moveReadOffset(4);
            this.slobLoc = new byte[0];
        }
        int patternLen = reader.readInt32();
        this.pattern = reader.readDBDecodedPadString(patternLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgLobInstr msg = (TbMsgLobInstr)obj;
        if (this.offsetHigh != msg.offsetHigh) {
            return false;
        }
        if (this.offsetLow != msg.offsetLow) {
            return false;
        }
        if (this.slobLoc == null && msg.slobLoc != null || this.slobLoc != null && msg.slobLoc == null) {
            return false;
        }
        if (this.slobLoc != null && msg.slobLoc != null) {
            if (this.slobLoc.length != msg.slobLoc.length) {
                return false;
            }
            for (int i = 0; i < msg.slobLoc.length; ++i) {
                if (this.slobLoc[i] == msg.slobLoc[i]) continue;
                return false;
            }
        }
        if (this.pattern == null && msg.pattern != null || this.pattern != null && msg.pattern == null) {
            return false;
        }
        return this.pattern == null || msg.pattern == null || this.pattern.equals(msg.pattern);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgLobInstr]/");
        str.append("offsetHigh=");
        str.append(this.offsetHigh);
        str.append("/");
        str.append("offsetLow=");
        str.append(this.offsetLow);
        str.append("/");
        str.append("slobLoc=");
        if (this.slobLoc != null) {
            for (int i = 0; i < this.slobLoc.length; ++i) {
                str.append(this.slobLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("pattern=");
        str.append(this.pattern);
        str.append("/");
        return str.append("\n").toString();
    }
}

