/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgTsamScanresetRequest
extends TbMsg {
    public int scanid;
    public int flags;
    public byte[] key;
    public int keyLen;

    public TbMsgTsamScanresetRequest(int autoCommit) {
        this.msgType = 98;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int scanid, int flags, byte[] key, int keyLen) {
        this.scanid = scanid;
        this.flags = flags;
        this.key = key;
        this.keyLen = keyLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.scanid, 4);
        writer.writeInt(this.flags, 4);
        if (this.keyLen != 0) {
            writer.writeInt(this.keyLen, 4);
            writer.writePadBytes(this.key, 0, this.keyLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.scanid = reader.readInt32();
        this.flags = reader.readInt32();
        int keyLen = reader.readInt32();
        if (keyLen != 0) {
            this.key = new byte[keyLen];
            reader.readPadBytes(this.key, 0, keyLen);
        } else {
            reader.moveReadOffset(4);
            this.key = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgTsamScanresetRequest msg = (TbMsgTsamScanresetRequest)obj;
        if (this.scanid != msg.scanid) {
            return false;
        }
        if (this.flags != msg.flags) {
            return false;
        }
        if (this.key == null && msg.key != null || this.key != null && msg.key == null) {
            return false;
        }
        if (this.key != null && msg.key != null) {
            if (this.key.length != msg.key.length) {
                return false;
            }
            for (int i = 0; i < msg.key.length; ++i) {
                if (this.key[i] == msg.key[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgTsamScanresetRequest]/");
        str.append("scanid=");
        str.append(this.scanid);
        str.append("/");
        str.append("flags=");
        str.append(this.flags);
        str.append("/");
        str.append("key=");
        if (this.key != null) {
            for (int i = 0; i < this.key.length; ++i) {
                str.append(this.key[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

