/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.util.TbCalendar;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbStatementLogBindData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

public class TbStatementLog {
    private String sql = null;
    private TbStatementLogBindData[] bindDataList = null;

    public TbStatementLog(String sql, TbStatementLogBindData[] bindDataList) {
        this.sql = sql;
        this.bindDataList = bindDataList;
    }

    public String getSql() {
        if (this.sql != null) {
            return this.sql;
        }
        return null;
    }

    public int getParamCnt() {
        if (this.bindDataList != null) {
            return this.bindDataList.length;
        }
        return 0;
    }

    public void close() {
        this.sql = null;
        if (this.bindDataList != null) {
            for (int i = 0; i < this.bindDataList.length; ++i) {
                this.bindDataList[i].close();
                this.bindDataList[i] = null;
            }
            this.bindDataList = null;
        }
    }

    protected static void serializeData(BufferedOutputStream logOutStream, String sql, BindData bindData, DataTypeConverter typeConverter) throws IOException, SQLException {
        byte[] lenBytes = new byte[4];
        Date cur = new Date();
        TbCalendar ts = new TbCalendar();
        ts.setTime(cur);
        byte[] tsBytes = typeConverter.fromTimestamp(ts, 0);
        TbCommon.int2bytes(tsBytes.length, lenBytes, 0, 4);
        logOutStream.write(lenBytes);
        logOutStream.write(tsBytes);
        byte[] sqlBytes = sql.getBytes("EUC_KR");
        TbCommon.int2bytes(sqlBytes.length, lenBytes, 0, 4);
        logOutStream.write(lenBytes);
        logOutStream.write(sqlBytes);
        TbCommon.int2bytes(bindData.getParameterCnt(), lenBytes, 0, 4);
        logOutStream.write(lenBytes);
        for (int i = 0; i < bindData.getParameterCnt(); ++i) {
            TbStatementLogBindData.serializeData(logOutStream, bindData.getBindItem(i));
        }
        lenBytes = null;
        cur = null;
        ts = null;
        tsBytes = null;
        sqlBytes = null;
    }

    protected static TbStatementLog deserializeData(BufferedInputStream logInStream) throws IOException {
        byte[] lenBytes = new byte[4];
        TbStatementLogBindData[] bindDataList = null;
        int len = 0;
        if (logInStream.read(lenBytes) <= 0) {
            throw new EOFException();
        }
        len = TbCommon.byte2int(lenBytes, 0, 4);
        byte[] tsBytes = new byte[len];
        if (logInStream.read(tsBytes) <= 0) {
            throw new EOFException();
        }
        if (logInStream.read(lenBytes) <= 0) {
            throw new EOFException();
        }
        len = TbCommon.byte2int(lenBytes, 0, 4);
        byte[] sqlBytes = new byte[len];
        if (logInStream.read(sqlBytes) <= 0) {
            throw new EOFException();
        }
        if (logInStream.read(lenBytes) <= 0) {
            throw new EOFException();
        }
        len = TbCommon.byte2int(lenBytes, 0, 4);
        bindDataList = new TbStatementLogBindData[len];
        for (int i = 0; i < len; ++i) {
            bindDataList[i] = TbStatementLogBindData.deserializeData(logInStream);
        }
        TbStatementLog stmtLog = new TbStatementLog(new String(sqlBytes, "EUC_KR"), bindDataList);
        lenBytes = null;
        sqlBytes = null;
        tsBytes = null;
        return stmtLog;
    }

    protected void execute(Connection conn, DataTypeConverter typeConverter) throws SQLException {
        if (this.sql == null) {
            throw new SQLException("invalid sql");
        }
        PreparedStatement pstmt = conn.prepareStatement(this.sql);
        this.bindParam(pstmt, typeConverter);
        pstmt.executeUpdate();
        pstmt.close();
        pstmt = null;
    }

    private void bindParam(PreparedStatement pstmt, DataTypeConverter typeConverter) throws SQLException {
        block8: for (int i = 0; i < this.getParamCnt(); ++i) {
            TbStatementLogBindData bindData = this.bindDataList[i];
            if (bindData.getDataLength() == 0) {
                pstmt.setNull(i + 1, DataType.getSqlType(bindData.getDataType()));
                continue;
            }
            switch (bindData.getDataType()) {
                case 1: {
                    BigDecimal val = TbNumber.getBigDecimalFromRawBytes(bindData.getData(), 0, bindData.getDataLength());
                    pstmt.setBigDecimal(i + 1, val);
                    continue block8;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: {
                    String str = typeConverter.getDBDecodedString(bindData.getData());
                    pstmt.setString(i + 1, str);
                    continue block8;
                }
                case 4: 
                case 11: 
                case 12: {
                    pstmt.setBytes(i + 1, bindData.getData());
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                case 7: {
                    continue block8;
                }
                default: {
                    throw new SQLException("Not implemented data type in log statement");
                }
            }
        }
    }

    public void print(int stmtNo) {
        System.out.println("------------------------------------------");
        System.out.println("stmt no  : " + stmtNo);
        System.out.println("stmt sql : " + this.getSql());
        System.out.println("params : " + this.getParamCnt());
    }
}

