/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.PropertyUtil;
import org.apache.cxf.tools.util.URIParserUtil;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolContext {
    protected JavaModel javaModel;
    private Map<String, Object> paramMap;
    private String packageName;
    private boolean packageNameChanged;
    private Map<String, String> namespacePackageMap = new HashMap<String, String>();
    private Map<String, String> excludeNamespacePackageMap = new HashMap<String, String>();
    private List<InputSource> jaxbBindingFiles = new ArrayList<InputSource>();
    private List<String> excludePkgList = new ArrayList<String>();
    private List<String> excludeFileList = new ArrayList<String>();

    public void loadDefaultNS2Pck(InputStream ins) {
        try {
            PropertyUtil properties = new PropertyUtil();
            properties.load(ins);
            this.namespacePackageMap.putAll(properties.getMaps());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadDefaultExcludes(InputStream ins) {
        try {
            PropertyUtil properties = new PropertyUtil();
            properties.load(ins);
            this.namespacePackageMap.putAll(properties.getMaps());
            this.excludeNamespacePackageMap.putAll(properties.getMaps());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JavaModel getJavaModel() {
        return this.javaModel;
    }

    public void setJavaModel(JavaModel jModel) {
        this.javaModel = jModel;
    }

    public void addParameters(Map<String, Object> map) {
        for (String key : map.keySet()) {
            if (this.optionSet(key)) continue;
            this.put(key, map.get(key));
        }
    }

    public void setParameters(Map<String, Object> map) {
        this.paramMap = map;
    }

    public boolean containsKey(String key) {
        return this.paramMap == null ? false : this.paramMap.containsKey(key);
    }

    public Object get(String key) {
        return this.paramMap == null ? null : this.paramMap.get(key);
    }

    public Object get(String key, Object defaultValue) {
        if (!this.optionSet(key)) {
            return defaultValue;
        }
        return this.get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return clazz.cast(this.get(key));
    }

    public <T> T get(String key, Class<T> clazz, Object defaultValue) {
        return clazz.cast(this.get(key, defaultValue));
    }

    public <T> T get(Class<T> key) {
        return key.cast(this.get(key.getName()));
    }

    public <T> void put(Class<T> key, T value) {
        this.put(key.getName(), value);
    }

    public boolean getBooleanValue(String key, String defaultValue) {
        return Boolean.valueOf((String)this.get(key, defaultValue));
    }

    public void put(String key, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, Object>();
        }
        this.paramMap.put(key, value);
    }

    public void remove(String key) {
        if (this.paramMap == null) {
            return;
        }
        this.paramMap.remove(key);
    }

    public boolean optionSet(String key) {
        return this.get(key) != null;
    }

    public boolean isVerbose() {
        if (this.get("verbose") == null) {
            return false;
        }
        return this.get("verbose") == "verbose";
    }

    public boolean validateWSDL() {
        return this.get("validate") != null;
    }

    public void addNamespacePackageMap(String namespace, String pn) {
        this.namespacePackageMap.put(namespace, pn);
    }

    private String mapNamespaceToPackageName(String ns) {
        return this.namespacePackageMap.get(ns);
    }

    public boolean hasNamespace(String ns) {
        return this.namespacePackageMap.containsKey(ns);
    }

    public void addExcludeNamespacePackageMap(String namespace, String pn) {
        this.excludeNamespacePackageMap.put(namespace, pn);
        this.excludePkgList.add(pn);
    }

    public boolean hasExcludeNamespace(String ns) {
        return this.excludeNamespacePackageMap.containsKey(ns);
    }

    public String getExcludePackageName(String ns) {
        return this.excludeNamespacePackageMap.get(ns);
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
        this.packageNameChanged = true;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String mapPackageName(String ns) {
        if (this.hasNamespace(ns)) {
            return this.mapNamespaceToPackageName(ns);
        }
        if (this.getPackageName() != null) {
            return this.getPackageName();
        }
        return URIParserUtil.parsePackageName(ns, null);
    }

    public String getCustomizedNS(String ns) {
        return URIParserUtil.getNamespace(this.mapPackageName(ns));
    }

    public void setJaxbBindingFiles(List<InputSource> bindings) {
        this.jaxbBindingFiles = bindings;
    }

    public List<InputSource> getJaxbBindingFile() {
        return this.jaxbBindingFiles;
    }

    public boolean isExcludeNamespaceEnabled() {
        return this.excludeNamespacePackageMap.size() > 0;
    }

    public List<String> getExcludePkgList() {
        return this.excludePkgList;
    }

    public List<String> getExcludeFileList() {
        return this.excludeFileList;
    }

    public QName getQName(String key) {
        return this.getQName(key, null);
    }

    public QName getQName(String key, String defaultNamespace) {
        if (this.optionSet(key)) {
            String pns = (String)this.get(key);
            int pos = pns.indexOf("=");
            String localname = pns;
            if (pos != -1) {
                String ns = pns.substring(0, pos);
                localname = pns.substring(pos + 1);
                return new QName(ns, localname);
            }
            return new QName(defaultNamespace, localname);
        }
        return null;
    }

    public Map<String, String> getNamespacePackageMap() {
        return this.namespacePackageMap;
    }

    public boolean isPackageNameChanged() {
        return this.packageNameChanged;
    }
}

