/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.support;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.EgovIntegrationServiceResponse;
import egovframework.rte.itl.integration.message.simple.SimpleMessage;
import egovframework.rte.itl.integration.message.simple.SimpleMessageHeader;
import egovframework.rte.itl.integration.support.MessageSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DefaultResponse
implements EgovIntegrationServiceResponse {
    private Log LOG = LogFactory.getLog(this.getClass());
    protected MessageSender sender;
    protected long defaultTimeout;

    public DefaultResponse(MessageSender sender, long defaultTimeout) {
        this.sender = sender;
        this.defaultTimeout = defaultTimeout;
    }

    public EgovIntegrationMessage receive() {
        this.LOG.debug((Object)"receive without timeout. Call receive with defaultTimeout");
        return this.receive(this.defaultTimeout);
    }

    public EgovIntegrationMessage receive(long timeout) {
        this.LOG.debug((Object)"receive with timeout");
        this.LOG.debug((Object)"wait for the termination of MessageSender");
        try {
            this.sender.join(timeout);
        }
        catch (InterruptedException e) {
            this.LOG.debug((Object)"MessageSender was interrupted", (Throwable)e);
        }
        if (this.sender.isAlive()) {
            this.LOG.debug((Object)"MessageSender is alive over 'timeout'");
            this.sender.interrupt();
            SimpleMessageHeader responseHeader = new SimpleMessageHeader(this.sender.requestMessage.getHeader());
            responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.TIME_OUT);
            return new SimpleMessage(responseHeader);
        }
        this.LOG.debug((Object)"MessageSender finished to send and receive messages.");
        return this.sender.getResponseMessage();
    }
}

