/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.encryption.pbe;

import org.apache.commons.lang.ArrayUtils;

class NumberUtils {
    static byte[] byteArrayFromInt(int number) {
        byte b0 = (byte)(0xFF & number);
        byte b1 = (byte)(0xFF & number >> 8);
        byte b2 = (byte)(0xFF & number >> 16);
        byte b3 = (byte)(0xFF & number >> 24);
        return new byte[]{b3, b2, b1, b0};
    }

    static int intFromByteArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array into an int");
        }
        int result = 0xFF & byteArray[0];
        for (int i = 0; i < byteArray.length; ++i) {
            result = result << 8 | 0xFF & byteArray[i];
        }
        return result;
    }

    static byte[] processBigIntegerEncryptedByteArray(byte[] byteArray, int signum) {
        byte[] processedByteArray = ArrayUtils.clone((byte[])byteArray);
        if (processedByteArray.length > 4) {
            int expectedSize;
            int initialSize = processedByteArray.length;
            byte[] encryptedMessageExpectedSizeBytes = ArrayUtils.subarray((byte[])processedByteArray, (int)(initialSize - 4), (int)initialSize);
            if ((processedByteArray = ArrayUtils.subarray((byte[])processedByteArray, (int)0, (int)(initialSize - 4))).length != (expectedSize = NumberUtils.intFromByteArray(encryptedMessageExpectedSizeBytes))) {
                int sizeDifference = expectedSize - processedByteArray.length;
                byte[] padding = new byte[sizeDifference];
                for (int i = 0; i < sizeDifference; ++i) {
                    padding[i] = signum >= 0 ? 0 : -1;
                }
                processedByteArray = ArrayUtils.addAll((byte[])padding, (byte[])processedByteArray);
            }
        }
        return processedByteArray;
    }

    private NumberUtils() {
    }
}

