/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.scope;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapTransactionManager;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SessionScope {
    private static long nextId;
    private long id;
    private SqlMapClient sqlMapClient;
    private SqlMapExecutor sqlMapExecutor;
    private SqlMapTransactionManager sqlMapTxMgr;
    private int requestStackDepth = 0;
    private Transaction transaction;
    private TransactionState transactionState;
    private TransactionState savedTransactionState;
    private boolean inBatch = false;
    private Object batch;
    private boolean commitRequired;
    private Map preparedStatements = new HashMap();

    public SessionScope() {
        this.id = SessionScope.getNextId();
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapExecutor getSqlMapExecutor() {
        return this.sqlMapExecutor;
    }

    public void setSqlMapExecutor(SqlMapExecutor sqlMapExecutor) {
        this.sqlMapExecutor = sqlMapExecutor;
    }

    public SqlMapTransactionManager getSqlMapTxMgr() {
        return this.sqlMapTxMgr;
    }

    public void setSqlMapTxMgr(SqlMapTransactionManager sqlMapTxMgr) {
        this.sqlMapTxMgr = sqlMapTxMgr;
    }

    public boolean isInBatch() {
        return this.inBatch;
    }

    public void setInBatch(boolean inBatch) {
        this.inBatch = inBatch;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    public Object getBatch() {
        return this.batch;
    }

    public void setBatch(Object batch) {
        this.batch = batch;
    }

    public int getRequestStackDepth() {
        return this.requestStackDepth;
    }

    public void incrementRequestStackDepth() {
        ++this.requestStackDepth;
    }

    public void decrementRequestStackDepth() {
        --this.requestStackDepth;
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public void setCommitRequired(boolean commitRequired) {
        this.commitRequired = commitRequired;
    }

    public boolean hasPreparedStatementFor(String sql) {
        return this.preparedStatements.containsKey(sql);
    }

    public boolean hasPreparedStatement(PreparedStatement ps) {
        return this.preparedStatements.containsValue(ps);
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (!this.hasPreparedStatementFor(sql)) {
            throw new SqlMapException("Could not get prepared statement.  This is likely a bug.");
        }
        PreparedStatement ps = (PreparedStatement)this.preparedStatements.get(sql);
        return ps;
    }

    public void putPreparedStatement(SqlMapExecutorDelegate delegate, String sql, PreparedStatement ps) {
        if (delegate.isStatementCacheEnabled() && !this.isInBatch()) {
            if (this.hasPreparedStatementFor(sql)) {
                throw new SqlMapException("Duplicate prepared statement found.  This is likely a bug.");
            }
            this.preparedStatements.put(sql, ps);
        }
    }

    public void closePreparedStatements() {
        Iterator keys = this.preparedStatements.keySet().iterator();
        while (keys.hasNext()) {
            PreparedStatement ps = (PreparedStatement)this.preparedStatements.get(keys.next());
            try {
                ps.close();
            }
            catch (Exception exception) {}
        }
        this.preparedStatements.clear();
    }

    public void cleanup() {
        this.closePreparedStatements();
        this.preparedStatements.clear();
    }

    public boolean equals(Object parameterObject) {
        if (this == parameterObject) {
            return true;
        }
        if (!(parameterObject instanceof SessionScope)) {
            return false;
        }
        SessionScope sessionScope = (SessionScope)parameterObject;
        return this.id == sessionScope.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public static synchronized long getNextId() {
        return nextId++;
    }

    public void saveTransactionState() {
        this.savedTransactionState = this.transactionState;
    }

    public void recallTransactionState() {
        this.transactionState = this.savedTransactionState;
    }
}

