/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.userdetails.jdbc;

import egovframework.rte.fdl.security.userdetails.EgovUserDetails;
import egovframework.rte.fdl.security.userdetails.jdbc.EgovUsersByUsernameMapping;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.hierarchicalroles.RoleHierarchy;
import org.springframework.security.userdetails.jdbc.JdbcUserDetailsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovJdbcUserDetailsManager
extends JdbcUserDetailsManager {
    private EgovUserDetails userDetails = null;
    private EgovUsersByUsernameMapping usersByUsernameMapping;
    private String mapClass;
    private RoleHierarchy roleHierarchy = null;

    public void setMapClass(String mapClass) {
        this.mapClass = mapClass;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }

    protected void initDao() throws ApplicationContextException {
        super.initDao();
        try {
            this.initMappingSqlQueries();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.ClassNotFoundException : " + e.toString()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.NoSuchMethodException : " + e.toString()), (Throwable)e);
        }
        catch (InstantiationException e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.InstantiationException : " + e.toString()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.IllegalAccessException : " + e.toString()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.InvocationTargetException : " + e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)("EgovJdbcUserDetailsManager.initDao.Exception : " + e.toString()), (Throwable)e);
        }
    }

    private void initMappingSqlQueries() throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException, ClassNotFoundException, Exception {
        this.logger.debug((Object)("## EgovJdbcUserDetailsManager query : " + this.getUsersByUsernameQuery()));
        this.setUsersByUsernameQuery(this.getUsersByUsernameQuery());
        Class clazz = EgovObjectUtil.loadClass((String)this.mapClass);
        Constructor constructor = clazz.getConstructor(DataSource.class, String.class);
        Object[] params = new Object[]{this.getDataSource(), this.getUsersByUsernameQuery()};
        this.usersByUsernameMapping = (EgovUsersByUsernameMapping)((Object)constructor.newInstance(params));
    }

    protected List<String> loadUsersByUsername(String username) {
        return this.usersByUsernameMapping.execute(username);
    }

    public EgovUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List<String> users = this.loadUsersByUsername(username);
        if (users.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("JdbcDaoImpl.notFound", new Object[]{username}, "Username {0} not found"), (Object)username);
        }
        String obj = users.get(0);
        this.userDetails = (EgovUserDetails)((Object)obj);
        HashSet dbAuthsSet = new HashSet();
        dbAuthsSet.addAll(this.loadUserAuthorities(this.userDetails.getUsername()));
        ArrayList dbAuths = new ArrayList(dbAuthsSet);
        this.addCustomAuthorities(this.userDetails.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("EgovJdbcUserDetailsManager.noAuthority", new Object[]{username}, "User {0} has no GrantedAuthority"), (Object)username);
        }
        GrantedAuthority[] arrayAuths = dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
        GrantedAuthority[] authorities = this.roleHierarchy.getReachableGrantedAuthorities(arrayAuths);
        return new EgovUserDetails(this.userDetails.getUsername(), this.userDetails.getPassword(), this.userDetails.isEnabled(), true, true, true, authorities, this.userDetails.getEgovUserVO());
    }

    public EgovUserDetails getAuthenticatedUser() throws UsernameNotFoundException, DataAccessException {
        return this.loadUserByUsername(SecurityContextHolder.getContext().getAuthentication().getName());
    }
}

