/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lbel;

import java.io.IOException;
import java.util.Stack;
import org.apache.log4j.lbel.Node;
import org.apache.log4j.lbel.Operator;
import org.apache.log4j.lbel.ScanError;
import org.apache.log4j.lbel.Token;
import org.apache.log4j.lbel.TokenStream;
import org.apache.log4j.lbel.comparator.ClassComparator;
import org.apache.log4j.lbel.comparator.LevelComparator;
import org.apache.log4j.lbel.comparator.LoggerComparator;
import org.apache.log4j.lbel.comparator.MessageComparator;
import org.apache.log4j.lbel.comparator.MethodComparator;
import org.apache.log4j.lbel.comparator.PropertyComparator;
import org.apache.log4j.lbel.comparator.TimestampComparator;

class Parser {
    TokenStream ts;
    Stack stack = new Stack();

    Parser(TokenStream bexpTS) {
        this.ts = bexpTS;
    }

    Node parse() throws IOException, ScanError {
        this.ts.next();
        return this.bexp();
    }

    Node bexp() throws IOException, ScanError {
        Node result;
        Node bterm = this.bterm();
        Node bexpTail = this.bexpTail();
        if (bexpTail == null) {
            result = bterm;
        } else {
            result = bexpTail;
            result.setLeft(bterm);
        }
        return result;
    }

    Node bexpTail() throws IOException, ScanError {
        Token token = this.ts.getCurrent();
        switch (token.getType()) {
            case 10: {
                this.ts.next();
                Node or = new Node(1000, "OR");
                Node bterm = this.bterm();
                Node bexpTail = this.bexpTail();
                if (bexpTail == null) {
                    or.setRight(bterm);
                } else {
                    or.setRight(bexpTail);
                    bexpTail.setLeft(bterm);
                }
                return or;
            }
        }
        return null;
    }

    Node bterm() throws IOException, ScanError {
        Node result;
        Node bfactor = this.bfactor();
        Node btermTail = this.btermTail();
        if (btermTail == null) {
            result = bfactor;
        } else {
            result = btermTail;
            btermTail.setLeft(bfactor);
        }
        return result;
    }

    Node btermTail() throws IOException, ScanError {
        Token token = this.ts.getCurrent();
        switch (token.getType()) {
            case 11: {
                this.ts.next();
                Node and = new Node(1100, "AND");
                Node bfactor = this.bfactor();
                Node btermTail = this.btermTail();
                if (btermTail == null) {
                    and.setRight(bfactor);
                } else {
                    and.setRight(btermTail);
                    btermTail.setLeft(bfactor);
                }
                return and;
            }
        }
        return null;
    }

    Node bfactor() throws IOException, ScanError {
        Token token = this.ts.getCurrent();
        switch (token.getType()) {
            case 12: {
                this.ts.next();
                Node result = new Node(1200, "NOT");
                Node bsubfactor = this.bsubfactor();
                result.setLeft(bsubfactor);
                return result;
            }
        }
        return this.bsubfactor();
    }

    Node bsubfactor() throws IOException, ScanError {
        Token token = this.ts.getCurrent();
        switch (token.getType()) {
            case 1: {
                this.ts.next();
                return new Node(2, "TRUE");
            }
            case 2: {
                this.ts.next();
                return new Node(1, "FALSE");
            }
            case 40: {
                this.ts.next();
                Node result = this.bexp();
                Token token2 = this.ts.getCurrent();
                if (token2.getType() != 41) {
                    throw new IllegalStateException("Expected right parantheses but got" + token);
                }
                this.ts.next();
                return result;
            }
            case 100: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                String literal = this.getLiteral();
                return new Node(3, new LoggerComparator(operator, literal));
            }
            case 120: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                int levelInt = this.getLevelInt();
                return new Node(3, new LevelComparator(operator, levelInt));
            }
            case 110: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                String literal = this.getLiteral();
                return new Node(3, new MessageComparator(operator, literal));
            }
            case 180: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                String literal = this.getLiteral();
                return new Node(3, new MethodComparator(operator, literal));
            }
            case 170: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                String literal = this.getLiteral();
                return new Node(3, new ClassComparator(operator, literal));
            }
            case 130: {
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                return new Node(3, new TimestampComparator(operator, this.getLong()));
            }
            case 150: {
                this.ts.next();
                String key = this.getPropertyKey();
                this.ts.next();
                Operator operator = this.getOperator();
                this.ts.next();
                String literal = this.getLiteral();
                return new Node(3, new PropertyComparator(operator, key, literal));
            }
        }
        throw new IllegalStateException("Unexpected token " + token);
    }

    Operator getOperator() throws ScanError {
        Token token = this.ts.getCurrent();
        if (token.getType() == 30) {
            String value = (String)token.getValue();
            if ("=".equals(value)) {
                return new Operator(1);
            }
            if ("!=".equals(value)) {
                return new Operator(2);
            }
            if (">".equals(value)) {
                return new Operator(10);
            }
            if (">=".equals(value)) {
                return new Operator(11);
            }
            if ("<".equals(value)) {
                return new Operator(20);
            }
            if ("<=".equals(value)) {
                return new Operator(21);
            }
            if ("~".equals(value)) {
                return new Operator(30);
            }
            if ("!~".equals(value)) {
                return new Operator(31);
            }
            if ("childof".equals(value)) {
                return new Operator(40);
            }
            throw new ScanError("Unknown operator type [" + value + "]");
        }
        throw new ScanError("Expected operator token");
    }

    String getLiteral() throws ScanError {
        Token token = this.ts.getCurrent();
        if (token.getType() == 20) {
            return (String)token.getValue();
        }
        if (token.getType() == 190) {
            return null;
        }
        throw new ScanError("Expected LITERAL or NULL but got " + token);
    }

    long getLong() throws ScanError {
        Token token = this.ts.getCurrent();
        if (token.getType() == 21) {
            Long l = (Long)token.getValue();
            return l;
        }
        throw new ScanError("Expected LITERAL but got " + token);
    }

    int getLevelInt() throws ScanError {
        String levelStr = this.getLiteral();
        if ("DEBUG".equalsIgnoreCase(levelStr)) {
            return 10000;
        }
        if ("INFO".equalsIgnoreCase(levelStr)) {
            return 20000;
        }
        if ("WARN".equalsIgnoreCase(levelStr)) {
            return 30000;
        }
        if ("ERROR".equalsIgnoreCase(levelStr)) {
            return 40000;
        }
        throw new ScanError("Expected a level stirng got " + levelStr);
    }

    String getPropertyKey() throws IOException, ScanError {
        Token token = this.ts.getCurrent();
        if (token.getType() == 200) {
            this.ts.next();
            Token token2 = this.ts.getCurrent();
            if (token2.getType() == 20) {
                return (String)token2.getValue();
            }
            throw new ScanError("Expected LITERAL but got " + token2);
        }
        throw new ScanError("Expected '.' but got " + token);
    }
}

