/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    public static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;
    private CyclicBuffer buffer = null;

    public SocketHubAppender() {
        super(false);
    }

    public SocketHubAppender(int _port) {
        super(false);
        this.port = _port;
        this.activateOptions();
    }

    public void activateOptions() {
        this.startServer();
        super.activateOptions();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.getLogger().debug((Object)"closing SocketHubAppender {}", this.getName());
        this.closed = true;
        this.cleanUp();
        this.getLogger().debug((Object)"SocketHubAppender {} closed", this.getName());
    }

    public void cleanUp() {
        this.getLogger().debug("stopping ServerSocket");
        if (this.serverMonitor != null) {
            this.serverMonitor.stopMonitor();
            this.serverMonitor = null;
        }
        this.getLogger().debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream oos = (ObjectOutputStream)this.oosList.elementAt(0);
            if (oos == null) continue;
            try {
                oos.close();
            }
            catch (IOException e) {
                this.getLogger().error((Object)"could not close oos.", e);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent event) {
        if (event != null) {
            if (this.locationInfo) {
                event.getLocationInformation();
            }
            if (this.buffer != null) {
                this.buffer.add(event);
            }
        }
        if (event == null || this.oosList.size() == 0) {
            return;
        }
        int streamCount = 0;
        while (streamCount < this.oosList.size()) {
            ObjectOutputStream oos = null;
            try {
                oos = (ObjectOutputStream)this.oosList.elementAt(streamCount);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (oos == null) break;
            try {
                oos.writeObject(event);
                oos.flush();
                oos.reset();
            }
            catch (IOException e) {
                this.oosList.removeElementAt(streamCount);
                this.getLogger().debug("dropped connection");
                --streamCount;
            }
            ++streamCount;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBufferSize(int _bufferSize) {
        this.buffer = new CyclicBuffer(_bufferSize);
    }

    public int getBufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getMaxSize();
    }

    public void setLocationInfo(boolean _locationInfo) {
        this.locationInfo = _locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    static /* synthetic */ ULogger access$001(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$101(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$301(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$401(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$501(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$601(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$701(SocketHubAppender x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$801(SocketHubAppender x0) {
        return x0.getLogger();
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int _port, Vector _oosList) {
            this.port = _port;
            this.oosList = _oosList;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                ComponentBase.access$001((SocketHubAppender)SocketHubAppender.this).debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
                ComponentBase.access$101((SocketHubAppender)SocketHubAppender.this).debug("server monitor thread shut down");
            }
        }

        private void sendCachedEvents(ObjectOutputStream stream) throws IOException {
            if (SocketHubAppender.this.buffer != null) {
                int i = 0;
                while (i < SocketHubAppender.this.buffer.length()) {
                    stream.writeObject(SocketHubAppender.this.buffer.get(i));
                    ++i;
                }
                stream.flush();
                stream.reset();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(1000);
            }
            catch (Exception e) {
                ComponentBase.access$301((SocketHubAppender)SocketHubAppender.this).error((Object)"exception setting timeout, shutting down server socket.", e);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    serverSocket.setSoTimeout(1000);
                    if (true) ** GOTO lbl49
                }
                catch (SocketException e) {
                    ComponentBase.access$401((SocketHubAppender)SocketHubAppender.this).error((Object)"exception setting timeout, shutting down server socket.", e);
                    var7_5 = null;
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                do {
                    socket = null;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (SocketException e) {
                        ComponentBase.access$501((SocketHubAppender)SocketHubAppender.this).error((Object)"exception accepting socket, shutting down server socket.", e);
                        this.keepRunning = false;
                    }
                    catch (IOException e) {
                        ComponentBase.access$601((SocketHubAppender)SocketHubAppender.this).error((Object)"exception accepting socket.", e);
                    }
                    if (socket == null) continue;
                    try {
                        remoteAddress = socket.getInetAddress();
                        ComponentBase.access$701((SocketHubAppender)SocketHubAppender.this).debug("accepting connection from {} ({})", remoteAddress.getHostName(), remoteAddress.getHostAddress());
                        oos = new ObjectOutputStream(socket.getOutputStream());
                        if (SocketHubAppender.access$200(SocketHubAppender.this) != null && SocketHubAppender.access$200(SocketHubAppender.this).length() > 0) {
                            this.sendCachedEvents(oos);
                        }
                        this.oosList.addElement(oos);
                    }
                    catch (IOException e) {
                        ComponentBase.access$801((SocketHubAppender)SocketHubAppender.this).error((Object)"exception creating output stream on socket.", e);
                    }
lbl49:
                    // 4 sources

                } while (this.keepRunning);
                var7_6 = null;
            }
            catch (Throwable var6_17) {
                var7_7 = null;
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var6_17;
            }
            try {
                serverSocket.close();
            }
            catch (IOException e) {}
        }
    }
}

