/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class ExternSheetRecord
extends Record {
    public static final short sid = 23;
    private List _list = new ArrayList();

    public ExternSheetRecord() {
    }

    public ExternSheetRecord(RecordInputStream in) {
        int nItems = in.readShort();
        for (int i = 0; i < nItems; ++i) {
            RefSubRecord rec = new RefSubRecord(in);
            this._list.add(rec);
        }
    }

    public int getNumOfRefs() {
        return this._list.size();
    }

    public void addREFRecord(RefSubRecord rec) {
        this._list.add(rec);
    }

    public int getNumOfREFRecords() {
        return this._list.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int nItems = this._list.size();
        sb.append("[EXTERNSHEET]\n");
        sb.append("   numOfRefs     = ").append(nItems).append("\n");
        for (int i = 0; i < nItems; ++i) {
            sb.append("refrec         #").append(i).append(": ");
            sb.append(this.getRef(i).toString());
            sb.append('\n');
        }
        sb.append("[/EXTERNSHEET]\n");
        return sb.toString();
    }

    private int getDataSize() {
        return 2 + this._list.size() * 6;
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        int nItems = this._list.size();
        LittleEndian.putShort(data, 0 + offset, (short)23);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, nItems);
        int pos = 6;
        for (int i = 0; i < nItems; ++i) {
            this.getRef(i).serialize(offset + pos, data);
            pos += 6;
        }
        return dataSize + 4;
    }

    private RefSubRecord getRef(int i) {
        return (RefSubRecord)this._list.get(i);
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public short getSid() {
        return 23;
    }

    public int getExtbookIndexFromRefIndex(int refIndex) {
        return this.getRef(refIndex).getExtBookIndex();
    }

    public int findRefIndexFromExtBookIndex(int extBookIndex) {
        int nItems = this._list.size();
        for (int i = 0; i < nItems; ++i) {
            if (this.getRef(i).getExtBookIndex() != extBookIndex) continue;
            return i;
        }
        return -1;
    }

    public int getFirstSheetIndexFromRefIndex(int extRefIndex) {
        return this.getRef(extRefIndex).getFirstSheetIndex();
    }

    public int addRef(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
        this._list.add(new RefSubRecord(extBookIndex, firstSheetIndex, lastSheetIndex));
        return this._list.size() - 1;
    }

    public int getRefIxForSheet(int externalBookIndex, int sheetIndex) {
        int nItems = this._list.size();
        for (int i = 0; i < nItems; ++i) {
            RefSubRecord ref = this.getRef(i);
            if (ref.getExtBookIndex() != externalBookIndex || ref.getFirstSheetIndex() != sheetIndex || ref.getLastSheetIndex() != sheetIndex) continue;
            return i;
        }
        return -1;
    }

    public static ExternSheetRecord combine(ExternSheetRecord[] esrs) {
        ExternSheetRecord result = new ExternSheetRecord();
        for (int i = 0; i < esrs.length; ++i) {
            ExternSheetRecord esr = esrs[i];
            int nRefs = esr.getNumOfREFRecords();
            for (int j = 0; j < nRefs; ++j) {
                result.addREFRecord(esr.getRef(j));
            }
        }
        return result;
    }

    private final class RefSubRecord {
        public static final int ENCODED_SIZE = 6;
        private int _extBookIndex;
        private int _firstSheetIndex;
        private int _lastSheetIndex;

        public RefSubRecord(int extBookIndex, int firstSheetIndex, int lastSheetIndex) {
            this._extBookIndex = extBookIndex;
            this._firstSheetIndex = firstSheetIndex;
            this._lastSheetIndex = lastSheetIndex;
        }

        public RefSubRecord(RecordInputStream in) {
            this(in.readShort(), in.readShort(), in.readShort());
        }

        public int getExtBookIndex() {
            return this._extBookIndex;
        }

        public int getFirstSheetIndex() {
            return this._firstSheetIndex;
        }

        public int getLastSheetIndex() {
            return this._lastSheetIndex;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("extBook=").append(this._extBookIndex);
            buffer.append(" firstSheet=").append(this._firstSheetIndex);
            buffer.append(" lastSheet=").append(this._lastSheetIndex);
            return buffer.toString();
        }

        public void serialize(int offset, byte[] data) {
            LittleEndian.putUShort(data, 0 + offset, this._extBookIndex);
            LittleEndian.putUShort(data, 2 + offset, this._firstSheetIndex);
            LittleEndian.putUShort(data, 4 + offset, this._lastSheetIndex);
        }
    }
}

