/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbClobReader;
import com.tmax.tibero.jdbc.TbClobWriter;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class TbClob
extends TbLob
implements Clob {
    private static final TbClob EMPTY_CLOB = new TbClob(null, new byte[1]);
    private static final TbClob EMPTY_NCLOB = new TbClob(null, new byte[1]);

    public TbClob(TbConnection conn, byte[] locator) {
        super(conn, locator);
    }

    private TbClobAccessor getClobAccessor() {
        return this.getConnection().getClobAccessor();
    }

    public long length() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getClobAccessor().length(this);
    }

    public String getSubString(long pos, int size) throws SQLException {
        this.checkInvalidActionOnEmpty();
        String ret = null;
        if (size < 0 || pos < 1L) {
            throw new TbSQLException(-590713);
        }
        if (size == 0) {
            ret = new String();
        } else {
            char[] read = new char[size];
            long numRead = this.getChars(pos, read);
            ret = numRead > 0L ? new String(read, 0, (int)numRead) : new String();
            read = null;
        }
        return ret;
    }

    public int setString(long pos, String str) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (str == null) {
            throw new TbSQLException(-590713);
        }
        return (int)this.putChars(pos, str.toCharArray());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (len < 0) {
            throw new TbSQLException(-590713);
        }
        if (len == 0) {
            return 0;
        }
        char[] chars = new char[len];
        str.getChars(offset, offset + len, chars, 0);
        return (int)this.putChars(pos, chars);
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbClobReader(this);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (pos == 0L) {
            return new TbClobWriter(this);
        }
        return new TbClobWriter(this, pos);
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbLobOutputStream(this, pos);
    }

    public long position(String searchstr, long start) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getClobAccessor().position(this, searchstr.toCharArray(), start - 1L);
    }

    public long position(Clob searchLob, long start) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getClobAccessor().position(this, (TbClob)searchLob, start - 1L);
    }

    public long getChars(long offset, char[] buffer) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getChars(offset, buffer, buffer.length);
    }

    public long getChars(long offset, char[] buffer, long numChars) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getChars(offset, buffer, 0L, buffer.length);
    }

    public long getChars(long offset, char[] buffer, long bufOffset, long numChars) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (numChars < 0L || offset < 1L) {
            throw new TbSQLException(-590713);
        }
        if (numChars > (long)buffer.length) {
            numChars = buffer.length;
        }
        if (numChars == 0L) {
            return 0L;
        }
        return this.getClobAccessor().read(this, offset - 1L, buffer, bufOffset, numChars);
    }

    public long putChars(long offset, char[] buffer) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.putChars(offset, buffer, 0L, buffer.length);
    }

    public long putChars(long offset, char[] buffer, long numChars) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.putChars(offset, buffer, 0L, numChars);
    }

    public int putChars(long offset, char[] buffer, long bufOffset, long numChars) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (numChars < 0L || offset < 1L) {
            throw new TbSQLException(-590713);
        }
        if (bufOffset + numChars > (long)buffer.length) {
            numChars = (long)buffer.length - bufOffset;
        }
        if (numChars <= 0L) {
            return 0;
        }
        return (int)this.getClobAccessor().write(this, offset - 1L, buffer, bufOffset, numChars);
    }

    public void truncate(long newLength) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (newLength < 0L) {
            throw new TbSQLException(-590713);
        }
        this.getClobAccessor().truncate(this, newLength);
    }

    public static TbClob createTemporary(Connection conn) throws SQLException {
        if (conn == null) {
            throw new TbSQLException(-590713);
        }
        byte[] locator = ((TbConnection)conn).getClobAccessor().createTemporaryClob();
        return new TbClob((TbConnection)conn, locator);
    }

    public static TbClob createTemporaryNClob(Connection conn) throws SQLException {
        if (conn == null) {
            throw new TbSQLException(-590713);
        }
        byte[] locator = ((TbConnection)conn).getClobAccessor().createTemporaryNClob();
        return new TbClob((TbConnection)conn, locator);
    }

    public static void freeTemporary(TbClob clob) throws SQLException {
        if (clob == null) {
            throw new TbSQLException(-590713);
        }
        clob.freeTemporary();
    }

    public void freeTemporary() throws SQLException {
        this.getClobAccessor().freeTemporaryClob(this);
    }

    public void open(int mode) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (mode != 0 && mode != 1) {
            throw new TbSQLException(-590713);
        }
        this.getClobAccessor().open(this, mode);
    }

    public void close() throws SQLException {
        this.checkInvalidActionOnEmpty();
        this.getClobAccessor().close(this);
    }

    public static TbClob createEmptyClob() {
        return EMPTY_CLOB;
    }

    public static TbClob createEmptyNClob() {
        return EMPTY_NCLOB;
    }

    public int getBufferSize() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return TbLob.MAX_CHUNK_SIZE;
    }
}

