/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbSQLException;
import java.sql.SQLException;

public abstract class TbLob {
    private TbConnection conn = null;
    private byte[] locator = null;
    private byte[] data = null;
    private boolean endOfStream = false;
    private boolean isEmpty = false;
    public static int MAX_CHUNK_SIZE = 32000;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    public static final int LOBLOC_LEN = 64;
    public static final int LOBLOC_DATA_APPENDED = 4;

    public TbLob(TbConnection conn, byte[] locator) {
        this.conn = conn;
        if (locator.length == 1) {
            this.locator = locator;
            this.isEmpty = true;
        } else if ((locator[5] & 4) == 4) {
            this.locator = new byte[64];
            System.arraycopy(locator, 0, this.locator, 0, 64);
            int dataLen = locator.length - 64;
            this.data = new byte[dataLen];
            System.arraycopy(locator, 64, this.data, 0, dataLen);
        } else {
            this.locator = locator;
        }
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public byte[] getLobData() {
        return this.data;
    }

    public int getLocatorLength() {
        if (this.locator == null) {
            return 0;
        }
        return this.locator.length;
    }

    public void setLocator(byte[] locator) {
        this.locator = null;
        this.locator = locator;
    }

    public void setConnection(TbConnection conn) {
        this.conn = conn;
    }

    public TbConnection getConnection() {
        return this.conn;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public void setEndOfStream(boolean flag) {
        this.endOfStream = flag;
    }

    public void checkInvalidActionOnEmpty() throws SQLException {
        if (this.isEmpty) {
            throw new TbSQLException(-90629);
        }
    }

    public abstract void open(int var1) throws SQLException;

    public abstract void close() throws SQLException;
}

