/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.Row;
import java.sql.SQLException;

public class TbRSFwOnly
extends TbResultSetBase {
    protected int curRowCnt = 0;
    protected int lastFetchedCnt = 0;
    private boolean isResetRows = true;

    protected TbRSFwOnly(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt);
        this.currentRowIndex = -1;
        this.lastFetchedCnt = 0;
        this.growRawDataArray(this.colCnt);
        this.makeRowDataArray(this.fetchSize);
    }

    public int addRows(Row[] rows) throws SQLException {
        this.lastFetchedCnt = this.rowsFetchedCnt;
        this.rowsFetchedCnt += this.curRowCnt;
        return this.curRowCnt;
    }

    private void checkRowIndex(int rowIndex) throws SQLException {
        if (rowIndex < 0) {
            throw new TbSQLException(-90635);
        }
        if (rowIndex >= this.rowsFetchedCnt && this.fetchComplete) {
            throw new TbSQLException(-90624);
        }
        if (rowIndex < this.lastFetchedCnt || rowIndex >= this.rowsFetchedCnt) {
            throw new TbSQLException(-90624);
        }
    }

    protected Row getCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        return this.stmt.rows[this.currentRowIndex - this.lastFetchedCnt];
    }

    protected Row getRowAt(int rowIndex) throws SQLException {
        this.checkRowIndex(rowIndex);
        return this.stmt.rows[rowIndex - this.lastFetchedCnt];
    }

    public Row[] getRows(int rowCnt) throws SQLException {
        this.curRowCnt = rowCnt;
        this.makeRowDataArray(rowCnt);
        return this.stmt.rows;
    }

    public void growRawDataArray(int newColCnt) {
        int i;
        if (this.stmt.rows == null) {
            return;
        }
        if (this.stmt.rows[0].getRawDataCnt() < newColCnt) {
            for (i = 0; i < this.stmt.rows.length; ++i) {
                this.stmt.rows[i].growRawDataArray(newColCnt);
            }
        }
        if (this.stmt.rows[0].getColCnt() != newColCnt) {
            for (i = 0; i < this.stmt.rows.length; ++i) {
                this.stmt.rows[i].setColCnt(newColCnt);
            }
        }
    }

    private void makeRowDataArray(int rowCnt) {
        block3: {
            block2: {
                if (this.stmt.rows != null) break block2;
                this.stmt.rows = new Row[rowCnt];
                for (int i = 0; i < rowCnt; ++i) {
                    this.stmt.rows[i] = new Row(this.colCnt);
                }
                break block3;
            }
            if (this.stmt.rows.length >= rowCnt) break block3;
            Row[] tmp = this.stmt.rows;
            this.stmt.rows = new Row[rowCnt];
            System.arraycopy(tmp, 0, this.stmt.rows, 0, tmp.length);
            int arrayCnt = this.stmt.rows[0].getRawDataCnt();
            for (int i = tmp.length; i < rowCnt; ++i) {
                this.stmt.rows[i] = new Row(this.colCnt, arrayCnt);
            }
        }
    }

    public synchronized boolean next() throws SQLException {
        if (!super.next()) {
            this.closeCursor();
            return false;
        }
        return true;
    }

    protected void removeCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        Row row = this.getCurrentRow();
        row.setDeleted(true);
    }

    protected void reset() {
        if (this.stmt.rows != null && this.stmt.getRealRsetType().getRank() == 2) {
            for (int i = 0; i < this.stmt.rows.length; ++i) {
                if (!this.isResetRows) continue;
                this.stmt.rows[i].reset();
            }
        }
        super.reset();
    }

    public void setResetRows(boolean isResetRows) {
        this.isResetRows = isResetRows;
    }

    protected void setRowAt(int rowIndex, Row row) throws SQLException {
        this.checkRowIndex(rowIndex);
        this.stmt.rows[rowIndex - this.lastFetchedCnt] = row;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(" lastFetchedCnt[").append(this.lastFetchedCnt).append("]");
        buf.append(super.ToString());
        return buf.toString();
    }
}

