/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbNrowId {
    static final int NROWID_BYTE_CNT = 8;
    static final int NEROWID_LEN = 11;
    static final int NEROWID_VAL_LAST = 10;
    static final int NEROWID_REMAINDER_BIT = 63;
    static final int NEROWID_DIVISION_SHIFT = 6;
    byte[] nrowid = null;
    static final byte[] nrowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public void TbNrowid() {
        this.nrowid = new byte[8];
    }

    public String toString() {
        long val = new Long(this.nrowid.toString());
        byte[] nerowid = new byte[11];
        for (int n = 10; n >= 0; --n) {
            nerowid[n] = nrowid_encoding[(int)val & 0x3F];
            val >>= 6;
        }
        return new String(nerowid);
    }

    public byte[] getServerBytes(int serverEndian, String data) throws SQLException {
        int k = 0;
        long nrowidNum = 0L;
        byte[] nerowid = data.getBytes();
        byte[] nrowid = new byte[8];
        k = 1;
        int n = 10;
        while (n > 0) {
            int c = TbNrowId.makeRowIdToInt(nerowid[n]);
            if (c < 0) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            if (Long.MAX_VALUE - nrowidNum < (long)(k * c)) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            nrowidNum += (long)(k * c);
            --n;
            k <<= 6;
        }
        if (serverEndian == 1) {
            TbCommon.long2bytes(nrowidNum, nrowid, 0, 8);
        } else {
            TbCommon.long2bytes(nrowidNum, nrowid, 0, 8);
        }
        return nrowid;
    }

    private static int makeRowIdToInt(byte c) {
        return 65 <= c && c <= 90 ? c - 65 + 0 : (97 <= c && c <= 122 ? c - 97 + 26 : (48 <= c && c <= 57 ? c - 48 + 52 : (43 == c ? 62 : (47 == c ? 63 : -1))));
    }
}

