/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;

public class UTF8CharToByteConverter {
    protected boolean subMode;
    protected byte[] subBytes = new byte[]{63};

    public boolean canConvert(char c) {
        return true;
    }

    public int convert(char[] ac, int i, int j, byte[] abyte0, int k, int l) throws TbSQLException {
        int charOff = 0;
        int byteOff = 0;
        int highHalfZoneCode = 0;
        byte[] abyte1 = new byte[6];
        charOff = i;
        byteOff = k;
        if (highHalfZoneCode != 0) {
            highHalfZoneCode = 0;
            if (ac[i] >= '\udc00' && ac[i] <= '\udfff') {
                int i1 = (highHalfZoneCode - 55296) * 1024 + (ac[i] - 56320) + 65536;
                abyte0[0] = (byte)(0xF0 | i1 >> 18 & 7);
                abyte0[1] = (byte)(0x80 | i1 >> 12 & 0x3F);
                abyte0[2] = (byte)(0x80 | i1 >> 6 & 0x3F);
                abyte0[3] = (byte)(0x80 | i1 & 0x3F);
                ++charOff;
                highHalfZoneCode = 0;
            } else {
                throw new TbSQLException(-590714, "Unknown character");
            }
        }
        while (charOff < j) {
            int byte1;
            int byte0;
            int c1 = ac[charOff];
            if (c1 < 128) {
                abyte1[0] = (byte)c1;
                byte0 = 1;
                byte1 = 1;
            } else if (c1 < 2048) {
                abyte1[0] = (byte)(0xC0 | c1 >> 6 & 0x1F);
                abyte1[1] = (byte)(0x80 | c1 & 0x3F);
                byte0 = 1;
                byte1 = 2;
            } else if (c1 >= 55296 && c1 <= 56319) {
                if (charOff + 1 >= j) {
                    highHalfZoneCode = c1;
                    break;
                }
                char c2 = ac[charOff + 1];
                if (c2 < '\udc00' || c2 > '\udfff') {
                    throw new TbSQLException(-590714, "Unknown character");
                }
                int k1 = (c1 - 55296) * 1024 + (c2 - 56320) + 65536;
                abyte1[0] = (byte)(0xF0 | k1 >> 18 & 7);
                abyte1[1] = (byte)(0x80 | k1 >> 12 & 0x3F);
                abyte1[2] = (byte)(0x80 | k1 >> 6 & 0x3F);
                abyte1[3] = (byte)(0x80 | k1 & 0x3F);
                byte1 = 4;
                byte0 = 2;
            } else {
                abyte1[0] = (byte)(0xE0 | c1 >> 12 & 0xF);
                abyte1[1] = (byte)(0x80 | c1 >> 6 & 0x3F);
                abyte1[2] = (byte)(0x80 | c1 & 0x3F);
                byte0 = 1;
                byte1 = 3;
            }
            if (byteOff + byte1 > l) {
                throw new TbSQLException(-590714, "Unknown character");
            }
            for (int j1 = 0; j1 < byte1; ++j1) {
                abyte0[byteOff++] = abyte1[j1];
            }
            charOff += byte0;
        }
        return byteOff - k;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }
}

