/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsg2pcPrepare
extends TbMsg {
    public String dbName;
    public int isCpsBranch;

    public TbMsg2pcPrepare(int autoCommit) {
        this.msgType = 116;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(String dbName, int isCpsBranch) {
        this.dbName = dbName;
        this.isCpsBranch = isCpsBranch;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.dbName != null) {
            writer.writeLenAndDBEncodedPadString(this.dbName);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.isCpsBranch, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int dbNameLen = reader.readInt32();
        this.dbName = reader.readDBDecodedPadString(dbNameLen);
        this.isCpsBranch = reader.readInt32();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsg2pcPrepare msg = (TbMsg2pcPrepare)obj;
        if (this.dbName == null && msg.dbName != null || this.dbName != null && msg.dbName == null) {
            return false;
        }
        if (this.dbName != null && msg.dbName != null && !this.dbName.equals(msg.dbName)) {
            return false;
        }
        return this.isCpsBranch == msg.isCpsBranch;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsg2pcPrepare]/");
        str.append("dbName=");
        str.append(this.dbName);
        str.append("/");
        str.append("isCpsBranch=");
        str.append(this.isCpsBranch);
        str.append("/");
        return str.append("\n").toString();
    }
}

