/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgTbcmSyncCtrlf
extends TbMsg {
    public byte[] file;
    public int fileLen;

    public TbMsgTbcmSyncCtrlf(int autoCommit) {
        this.msgType = 133;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] file, int fileLen) {
        this.file = file;
        this.fileLen = fileLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.fileLen != 0) {
            writer.writeInt(this.fileLen, 4);
            writer.writePadBytes(this.file, 0, this.fileLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int fileLen = reader.readInt32();
        if (fileLen != 0) {
            this.file = new byte[fileLen];
            reader.readPadBytes(this.file, 0, fileLen);
        } else {
            reader.moveReadOffset(4);
            this.file = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgTbcmSyncCtrlf msg = (TbMsgTbcmSyncCtrlf)obj;
        if (this.file == null && msg.file != null || this.file != null && msg.file == null) {
            return false;
        }
        if (this.file != null && msg.file != null) {
            if (this.file.length != msg.file.length) {
                return false;
            }
            for (int i = 0; i < msg.file.length; ++i) {
                if (this.file[i] == msg.file[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgTbcmSyncCtrlf]/");
        str.append("file=");
        if (this.file != null) {
            for (int i = 0; i < this.file.length; ++i) {
                str.append(this.file[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

