/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgXa
extends TbMsg {
    public int msgtype;
    public int flags;
    public byte[] xid;
    public int xidLen;
    public int looseCoupling;

    public TbMsgXa(int autoCommit) {
        this.msgType = 69;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int msgtype, int flags, byte[] xid, int xidLen, int looseCoupling) {
        this.msgtype = msgtype;
        this.flags = flags;
        this.xid = xid;
        this.xidLen = xidLen;
        this.looseCoupling = looseCoupling;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.msgtype, 4);
        writer.writeInt(this.flags, 4);
        if (this.xidLen != 0) {
            writer.writeInt(this.xidLen, 4);
            writer.writePadBytes(this.xid, 0, this.xidLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.looseCoupling, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.msgtype = reader.readInt32();
        this.flags = reader.readInt32();
        int xidLen = reader.readInt32();
        if (xidLen != 0) {
            this.xid = new byte[xidLen];
            reader.readPadBytes(this.xid, 0, xidLen);
        } else {
            reader.moveReadOffset(4);
            this.xid = new byte[0];
        }
        this.looseCoupling = reader.readInt32();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgXa msg = (TbMsgXa)obj;
        if (this.msgtype != msg.msgtype) {
            return false;
        }
        if (this.flags != msg.flags) {
            return false;
        }
        if (this.xid == null && msg.xid != null || this.xid != null && msg.xid == null) {
            return false;
        }
        if (this.xid != null && msg.xid != null) {
            if (this.xid.length != msg.xid.length) {
                return false;
            }
            for (int i = 0; i < msg.xid.length; ++i) {
                if (this.xid[i] == msg.xid[i]) continue;
                return false;
            }
        }
        return this.looseCoupling == msg.looseCoupling;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgXa]/");
        str.append("msgtype=");
        str.append(this.msgtype);
        str.append("/");
        str.append("flags=");
        str.append(this.flags);
        str.append("/");
        str.append("xid=");
        if (this.xid != null) {
            for (int i = 0; i < this.xid.length; ++i) {
                str.append(this.xid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("looseCoupling=");
        str.append(this.looseCoupling);
        str.append("/");
        return str.append("\n").toString();
    }
}

