/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.TbSQLException;
import java.sql.SQLException;

public class TbSqlParser {
    private static String originalSql;
    private static int length;
    private static StringBuffer parsedSql;
    private static StringBuffer token;
    private static char chr;
    private static int index;
    private static int openParenCnt;
    private static boolean isLocate;
    private static boolean isString;

    public static int getParamCount(String sql) {
        int index = 0;
        int paramCount = 0;
        char[] sqlChars = new char[sql.length() + 1];
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                index += 2;
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '\"') {
                ++index;
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '\'') {
                ++index;
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                index += 2;
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                index += 2;
                continue;
            }
            if (sqlChars[index] == '\u0000') {
                return paramCount;
            }
            if (sqlChars[index] == '?' || sqlChars[index] == ':' && sqlChars[index + 1] != '=') {
                ++paramCount;
            }
            ++index;
        }
    }

    public static String replace(String sql) {
        int index = 0;
        char[] sqlChars = new char[sql.length() + 1];
        StringBuffer returnedSql = new StringBuffer(sql.length());
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\"') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\'') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                continue;
            }
            if (sqlChars[index] == '\u0000') {
                return returnedSql.toString();
            }
            if (sqlChars[index] == '?' && Character.isDigit(sqlChars[index + 1])) {
                int beginIndex = index;
                index += 2;
                while (Character.isDigit(sqlChars[index])) {
                    ++index;
                }
                if (Character.isLetter(sqlChars[index])) {
                    returnedSql.append(sql.substring(beginIndex, index));
                    continue;
                }
                returnedSql.append(":");
                returnedSql.append(sql.substring(beginIndex + 1, index));
                continue;
            }
            returnedSql.append(sqlChars[index]);
            ++index;
        }
    }

    private static void init() {
        index = 0;
        openParenCnt = 0;
        isString = false;
        isLocate = false;
    }

    public static synchronized String parse(String sql) throws SQLException {
        TbSqlParser.init();
        parsedSql = new StringBuffer(sql.length());
        token = new StringBuffer(32);
        originalSql = sql;
        length = originalSql.length();
        TbSqlParser.processSQL();
        return parsedSql.substring(0, parsedSql.length());
    }

    private static void processSQL() throws SQLException {
        StringBuffer argOne = null;
        StringBuffer argTwo = null;
        boolean argTwoStart = false;
        block5: while (index < length) {
            chr = originalSql.charAt(index++);
            char nextChr = '\u0000';
            if (isString) {
                parsedSql.append(chr);
                if (chr != '\'') continue;
                isString = false;
                continue;
            }
            switch (chr) {
                case '\'': {
                    if (isLocate) {
                        if (argOne == null) {
                            argOne = new StringBuffer();
                            argTwo = new StringBuffer();
                        }
                        if (!argTwoStart) {
                            argOne.append(chr);
                            continue block5;
                        }
                        argTwo.append(chr);
                        continue block5;
                    }
                    parsedSql.append(chr);
                    isString = true;
                    continue block5;
                }
                case '{': {
                    ++openParenCnt;
                    token.delete(0, token.length());
                    TbSqlParser.skipWhitespace();
                    TbSqlParser.makeToken();
                    TbSqlParser.processToken();
                    TbSqlParser.checkCurrentChar('}');
                    continue block5;
                }
                case '}': {
                    if (--openParenCnt < 0) {
                        String errorDescription = new String(index + ": Unnecessary '" + chr + "' exists");
                        throw new TbSQLException(-90632, errorDescription);
                    }
                    return;
                }
            }
            if (index < length) {
                nextChr = originalSql.charAt(index);
            }
            if (chr == '/' && nextChr == '*') {
                parsedSql.append(chr);
                parsedSql.append(nextChr);
                do {
                    chr = originalSql.charAt(++index);
                    nextChr = originalSql.charAt(index + 1);
                    parsedSql.append(chr);
                } while (chr != '*' || nextChr != '/');
                continue;
            }
            if (chr == '-' && nextChr == '-') {
                parsedSql.append(chr);
                parsedSql.append(nextChr);
                ++index;
                while (index < length && (chr = originalSql.charAt(index)) != '\n') {
                    parsedSql.append(chr);
                    ++index;
                }
                continue;
            }
            if (isLocate && chr != ' ' && chr != '(') {
                if (chr == ')') {
                    parsedSql.append(argTwo);
                    parsedSql.append(", ");
                    parsedSql.append(argOne);
                    parsedSql.append(chr);
                    isLocate = false;
                }
                if (argOne == null) {
                    argOne = new StringBuffer();
                    argTwo = new StringBuffer();
                }
                if (chr == ',') {
                    argTwoStart = true;
                    continue;
                }
                if (!argTwoStart) {
                    argOne.append(chr);
                    continue;
                }
                argTwo.append(chr);
                continue;
            }
            parsedSql.append(chr);
        }
    }

    private static void checkCurrentChar(char dueChar) throws SQLException {
        chr = originalSql.charAt(index - 1);
        if (chr != dueChar) {
            String errorDescription = new String(index + ": '" + dueChar + "' is expected");
            throw new TbSQLException(-90632, errorDescription);
        }
    }

    private static void processToken() throws SQLException {
        String curToken = token.substring(0, token.length());
        if (curToken.equalsIgnoreCase("?")) {
            TbSqlParser.processFunction();
        } else if (curToken.equalsIgnoreCase("CALL")) {
            TbSqlParser.processCall();
        } else if (curToken.equalsIgnoreCase("TS")) {
            TbSqlParser.processTimestamp();
        } else if (curToken.equalsIgnoreCase("T")) {
            TbSqlParser.processTime();
        } else if (curToken.equalsIgnoreCase("D")) {
            TbSqlParser.processDate();
        } else if (curToken.equalsIgnoreCase("ESCAPE")) {
            TbSqlParser.processEscape();
        } else if (curToken.equalsIgnoreCase("FN")) {
            TbSqlParser.processScalarFunction();
        } else if (curToken.equalsIgnoreCase("OJ")) {
            TbSqlParser.processOuterJoin();
        } else {
            String errorDescription = new String(index + ": \"" + token + "\" token is not supported");
            throw new TbSQLException(-90632, errorDescription);
        }
    }

    private static void processFunction() throws SQLException {
        parsedSql.append("?");
        TbSqlParser.processSQL();
    }

    private static void processCall() throws SQLException {
        parsedSql.append("CALL");
        TbSqlParser.processSQL();
    }

    private static void processTimestamp() throws SQLException {
        parsedSql.append("TO_TIMESTAMP (");
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
        parsedSql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
    }

    private static void processTime() throws SQLException {
        parsedSql.append("TO_DATE (");
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
        parsedSql.append(", 'HH24:MI:SS')");
    }

    private static void processDate() throws SQLException {
        parsedSql.append("TO_DATE (");
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
        parsedSql.append(", 'YYYY-MM-DD')");
    }

    private static void processEscape() throws SQLException {
        parsedSql.append("ESCAPE ");
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
    }

    private static void processScalarFunction() throws SQLException {
        token.delete(0, token.length());
        TbSqlParser.skipWhitespace();
        TbSqlParser.makeToken();
        String functionName = token.substring(0, token.length()).toUpperCase().intern();
        if (functionName == "ABS") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "ACOS") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "ASIN") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "ATAN") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "ATAN2") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "CEILING") {
            TbSqlParser.appendFunctionName("CEIL");
        } else if (functionName == "COS") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "EXP") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "FLOOR") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "LOG") {
            TbSqlParser.appendFunctionName("LN");
        } else if (functionName == "LOG10") {
            TbSqlParser.appendFunctionPrefix("LOG ( 10, ");
        } else if (functionName.equals("MOD")) {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "PI") {
            TbSqlParser.appendFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if (functionName == "POWER") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "ROUND") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "SIGN") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "SIN") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "SQRT") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "TAN") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "TRUNCATE") {
            TbSqlParser.appendFunctionName("TRUNC");
        } else if (functionName == "ASCII") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "CHAR") {
            TbSqlParser.appendFunctionName("CHR");
        } else if (functionName == "CONCAT") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "LCASE") {
            TbSqlParser.appendFunctionName("LOWER");
        } else if (functionName == "LENGTH") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "LOCATE") {
            isLocate = true;
            TbSqlParser.appendFunctionName("INSTR");
        } else if (functionName == "LTRIM") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName.equals("REPLACE")) {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "RTRIM") {
            TbSqlParser.appendFunctionName(functionName);
        } else if (functionName == "SUBSTRING") {
            TbSqlParser.appendFunctionName("SUBSTR");
        } else if (functionName == "UCASE") {
            TbSqlParser.appendFunctionName("UPPER");
        } else if (functionName == "CURDATE") {
            TbSqlParser.appendFunctionPrefix("(CURRENT_DATE");
        } else if (functionName == "CURTIME") {
            TbSqlParser.appendFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (functionName == "DAYOFMONTH") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if (functionName == "HOUR") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if (functionName == "MINUTE") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if (functionName == "MONTH") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if (functionName == "NOW") {
            TbSqlParser.appendFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (functionName == "SECOND") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if (functionName == "YEAR") {
            TbSqlParser.appendFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if (functionName == "USER") {
            TbSqlParser.appendFunctionPrefix("(USER");
        } else {
            String errorDescription = new String("unsuppoted SQL92 Token: \"" + functionName + "\"");
            throw new TbSQLException(-90632, errorDescription);
        }
    }

    private static void processOuterJoin() throws SQLException {
        parsedSql.append(" ( ");
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
        parsedSql.append(" ) ");
    }

    private static void appendFunctionName(String newName) throws SQLException {
        parsedSql.append(newName);
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
    }

    private static void appendFunctionPrefix(String newPrefix) throws SQLException {
        TbSqlParser.skipWhitespace();
        if (index < length && (chr = originalSql.charAt(index)) == '(') {
            ++index;
        } else {
            String errorDescription = new String(index + ": '(' is expected");
            throw new TbSQLException(-90632, errorDescription);
        }
        parsedSql.append(newPrefix);
        TbSqlParser.skipWhitespace();
        TbSqlParser.processSQL();
    }

    private static void makeToken() {
        while (index < length && (Character.isJavaIdentifierPart(chr = originalSql.charAt(index)) || chr == '?')) {
            token.append(chr);
            ++index;
        }
    }

    private static void skipWhitespace() {
        while (index < length && ((chr = originalSql.charAt(index)) == ' ' || chr == '\t' || chr == '\r' || chr == '\n')) {
            parsedSql.append(chr);
            ++index;
        }
    }

    public static String getRowIdAddedSelectSql(String sql) throws SQLException {
        if (sql == null) {
            throw new TbSQLException(-90608, "null");
        }
        String upSql = sql.toUpperCase();
        int index = upSql.indexOf("SELECT");
        if (index == -1) {
            return null;
        }
        StringBuffer rowidBuf = new StringBuffer();
        rowidBuf.append("SELECT ROWID,").append(sql.substring(6 + index));
        return rowidBuf.toString();
    }

    public static String getRowIdAddedRefetchSql(String originalSql, int cnt) throws SQLException {
        if (originalSql == null) {
            throw new TbSQLException(-90608, "null");
        }
        if (cnt <= 0) {
            return originalSql;
        }
        String upperSql = originalSql.toUpperCase();
        StringBuffer sqlBuf = new StringBuffer(originalSql);
        if (upperSql.indexOf("WHERE") == -1) {
            sqlBuf.append(" WHERE ( ROWID = ? ");
        } else {
            sqlBuf.append(" AND ( ROWID = ? ");
        }
        for (int i = 1; i < cnt; ++i) {
            sqlBuf.append(" OR ROWID = ? ");
        }
        sqlBuf.append(" ) ");
        return sqlBuf.toString();
    }
}

