/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPProcessingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.axiom.AxiomSoap11Fault;
import org.springframework.ws.soap.axiom.AxiomSoapBody;
import org.springframework.ws.soap.axiom.AxiomSoapFaultException;
import org.springframework.ws.soap.axiom.support.AxiomUtils;
import org.springframework.ws.soap.soap11.Soap11Body;
import org.springframework.ws.soap.soap11.Soap11Fault;
import org.springframework.xml.namespace.QNameUtils;

class AxiomSoap11Body
extends AxiomSoapBody
implements Soap11Body {
    AxiomSoap11Body(SOAPBody axiomBody, SOAPFactory axiomFactory, boolean payloadCaching) {
        super(axiomBody, axiomFactory, payloadCaching);
    }

    public SoapFault addMustUnderstandFault(String faultString, Locale locale) {
        SOAPFault fault = this.addStandardFault("MustUnderstand", faultString, locale);
        return new AxiomSoap11Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addClientOrSenderFault(String faultString, Locale locale) {
        SOAPFault fault = this.addStandardFault("Client", faultString, locale);
        return new AxiomSoap11Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addServerOrReceiverFault(String faultString, Locale locale) {
        SOAPFault fault = this.addStandardFault("Server", faultString, locale);
        return new AxiomSoap11Fault(fault, this.getAxiomFactory());
    }

    public SoapFault addVersionMismatchFault(String faultString, Locale locale) {
        SOAPFault fault = this.addStandardFault("VersionMismatch", faultString, locale);
        return new AxiomSoap11Fault(fault, this.getAxiomFactory());
    }

    public Soap11Fault addFault(QName code, String faultString, Locale locale) {
        Assert.notNull((Object)code, (String)"No faultCode given");
        Assert.hasLength((String)faultString, (String)"faultString cannot be empty");
        if (!StringUtils.hasLength((String)code.getNamespaceURI())) {
            throw new IllegalArgumentException("A fault code with namespace and local part must be specific for a custom fault code");
        }
        try {
            AxiomUtils.removeContents((OMContainer)this.getAxiomBody());
            SOAPFault fault = this.getAxiomFactory().createSOAPFault(this.getAxiomBody());
            SOAPFaultCode faultCode = this.getAxiomFactory().createSOAPFaultCode(fault);
            this.setValueText(code, fault, faultCode);
            SOAPFaultReason faultReason = this.getAxiomFactory().createSOAPFaultReason(fault);
            if (locale != null) {
                this.addLangAttribute(locale, faultReason);
            }
            faultReason.setText(faultString);
            return new AxiomSoap11Fault(fault, this.getAxiomFactory());
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    private void setValueText(QName code, SOAPFault fault, SOAPFaultCode faultCode) {
        String prefix = QNameUtils.getPrefix((QName)code);
        if (StringUtils.hasLength((String)code.getNamespaceURI()) && StringUtils.hasLength((String)prefix)) {
            OMNamespace namespace = fault.findNamespaceURI(prefix);
            if (namespace == null) {
                fault.declareNamespace(code.getNamespaceURI(), prefix);
            }
        } else if (StringUtils.hasLength((String)code.getNamespaceURI())) {
            OMNamespace namespace = fault.findNamespace(code.getNamespaceURI(), null);
            if (namespace == null) {
                throw new IllegalArgumentException("Could not resolve namespace of code [" + code + "]");
            }
            code = QNameUtils.createQName((String)code.getNamespaceURI(), (String)code.getLocalPart(), (String)namespace.getPrefix());
        }
        faultCode.setText(code);
    }

    private SOAPFault addStandardFault(String localName, String faultString, Locale locale) {
        Assert.notNull((Object)faultString, (String)"No faultString given");
        try {
            AxiomUtils.removeContents((OMContainer)this.getAxiomBody());
            SOAPFault fault = this.getAxiomFactory().createSOAPFault(this.getAxiomBody());
            SOAPFaultCode faultCode = this.getAxiomFactory().createSOAPFaultCode(fault);
            faultCode.setText(QNameUtils.createQName((String)fault.getNamespace().getNamespaceURI(), (String)localName, (String)fault.getNamespace().getPrefix()));
            SOAPFaultReason faultReason = this.getAxiomFactory().createSOAPFaultReason(fault);
            if (locale != null) {
                this.addLangAttribute(locale, faultReason);
            }
            faultReason.setText(faultString);
            return fault;
        }
        catch (SOAPProcessingException ex) {
            throw new AxiomSoapFaultException(ex);
        }
    }

    private void addLangAttribute(Locale locale, SOAPFaultReason faultReason) {
        OMNamespace xmlNamespace = this.getAxiomFactory().createOMNamespace("http://www.w3.org/XML/1998/namespace", "xml");
        OMAttribute langAttribute = this.getAxiomFactory().createOMAttribute("lang", xmlNamespace, AxiomUtils.toLanguage(locale));
        faultReason.addAttribute(langAttribute);
    }

    public SoapFault getFault() {
        SOAPFault axiomFault = this.getAxiomBody().getFault();
        return axiomFault != null ? new AxiomSoap11Fault(axiomFault, this.getAxiomFactory()) : null;
    }
}

