/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.util.WebUtils;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageReceiver;
import org.springframework.ws.transport.http.WebServiceMessageReceiverHandlerAdapter;
import org.springframework.ws.transport.http.WsdlDefinitionHandlerAdapter;
import org.springframework.ws.transport.http.XsdSchemaHandlerAdapter;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.xml.xsd.XsdSchema;

public class MessageDispatcherServlet
extends FrameworkServlet {
    public static final String DEFAULT_MESSAGE_FACTORY_BEAN_NAME = "messageFactory";
    public static final String DEFAULT_MESSAGE_RECEIVER_BEAN_NAME = "messageReceiver";
    public static final String DEFAULT_MESSAGE_RECEIVER_HANDLER_ADAPTER_BEAN_NAME = "messageReceiverHandlerAdapter";
    public static final String DEFAULT_WSDL_DEFINITION_HANDLER_ADAPTER_BEAN_NAME = "wsdlDefinitionHandlerAdapter";
    public static final String DEFAULT_XSD_SCHEMA_HANDLER_ADAPTER_BEAN_NAME = "xsdSchemaHandlerAdapter";
    private static final String DEFAULT_STRATEGIES_PATH = "MessageDispatcherServlet.properties";
    private static final String WSDL_SUFFIX_NAME = ".wsdl";
    private static final String XSD_SUFFIX_NAME = ".xsd";
    private final DefaultStrategiesHelper defaultStrategiesHelper = new DefaultStrategiesHelper((Resource)new ClassPathResource("MessageDispatcherServlet.properties", MessageDispatcherServlet.class));
    private String messageFactoryBeanName = "messageFactory";
    private String messageReceiverHandlerAdapterBeanName = "messageReceiverHandlerAdapter";
    private WebServiceMessageReceiverHandlerAdapter messageReceiverHandlerAdapter;
    private String wsdlDefinitionHandlerAdapterBeanName = "wsdlDefinitionHandlerAdapter";
    private WsdlDefinitionHandlerAdapter wsdlDefinitionHandlerAdapter;
    private String xsdSchemaHandlerAdapterBeanName = "xsdSchemaHandlerAdapter";
    private XsdSchemaHandlerAdapter xsdSchemaHandlerAdapter;
    private String messageReceiverBeanName = "messageReceiver";
    private WebServiceMessageReceiver messageReceiver;
    private Map wsdlDefinitions;
    private Map xsdSchemas;
    private boolean transformWsdlLocations = false;

    public String getMessageFactoryBeanName() {
        return this.messageFactoryBeanName;
    }

    public void setMessageFactoryBeanName(String messageFactoryBeanName) {
        this.messageFactoryBeanName = messageFactoryBeanName;
    }

    public String getMessageReceiverBeanName() {
        return this.messageReceiverBeanName;
    }

    public void setMessageReceiverBeanName(String messageReceiverBeanName) {
        this.messageReceiverBeanName = messageReceiverBeanName;
    }

    public boolean isTransformWsdlLocations() {
        return this.transformWsdlLocations;
    }

    public String getMessageReceiverHandlerAdapterBeanName() {
        return this.messageReceiverHandlerAdapterBeanName;
    }

    public void setMessageReceiverHandlerAdapterBeanName(String messageReceiverHandlerAdapterBeanName) {
        this.messageReceiverHandlerAdapterBeanName = messageReceiverHandlerAdapterBeanName;
    }

    public String getWsdlDefinitionHandlerAdapterBeanName() {
        return this.wsdlDefinitionHandlerAdapterBeanName;
    }

    public void setWsdlDefinitionHandlerAdapterBeanName(String wsdlDefinitionHandlerAdapterBeanName) {
        this.wsdlDefinitionHandlerAdapterBeanName = wsdlDefinitionHandlerAdapterBeanName;
    }

    public String getXsdSchemaHandlerAdapterBeanName() {
        return this.xsdSchemaHandlerAdapterBeanName;
    }

    public void setXsdSchemaHandlerAdapterBeanName(String xsdSchemaHandlerAdapterBeanName) {
        this.xsdSchemaHandlerAdapterBeanName = xsdSchemaHandlerAdapterBeanName;
    }

    public void setTransformWsdlLocations(boolean transformWsdlLocations) {
        this.transformWsdlLocations = transformWsdlLocations;
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        WsdlDefinition definition = this.getWsdlDefinition(httpServletRequest);
        if (definition != null) {
            this.wsdlDefinitionHandlerAdapter.handle(httpServletRequest, httpServletResponse, definition);
            return;
        }
        XsdSchema schema = this.getXsdSchema(httpServletRequest);
        if (schema != null) {
            this.xsdSchemaHandlerAdapter.handle(httpServletRequest, httpServletResponse, schema);
            return;
        }
        this.messageReceiverHandlerAdapter.handle(httpServletRequest, httpServletResponse, this.messageReceiver);
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.initMessageReceiverHandlerAdapter();
        this.initWsdlDefinitionHandlerAdapter();
        this.initXsdSchemaHandlerAdapter();
        this.initMessageReceiver();
        this.initWsdlDefinitions();
        this.initXsdSchemas();
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        WsdlDefinition definition = this.getWsdlDefinition(httpServletRequest);
        if (definition != null) {
            return this.wsdlDefinitionHandlerAdapter.getLastModified(httpServletRequest, definition);
        }
        XsdSchema schema = this.getXsdSchema(httpServletRequest);
        if (schema != null) {
            return this.xsdSchemaHandlerAdapter.getLastModified(httpServletRequest, schema);
        }
        return this.messageReceiverHandlerAdapter.getLastModified(httpServletRequest, this.messageReceiver);
    }

    protected WebServiceMessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    protected WsdlDefinition getWsdlDefinition(HttpServletRequest request) {
        if ("GET".equals(request.getMethod()) && request.getRequestURI().endsWith(WSDL_SUFFIX_NAME)) {
            String fileName = WebUtils.extractFilenameFromUrlPath((String)request.getRequestURI());
            return (WsdlDefinition)this.wsdlDefinitions.get(fileName);
        }
        return null;
    }

    protected XsdSchema getXsdSchema(HttpServletRequest request) {
        if ("GET".equals(request.getMethod()) && request.getRequestURI().endsWith(XSD_SUFFIX_NAME)) {
            String fileName = WebUtils.extractFilenameFromUrlPath((String)request.getRequestURI());
            return (XsdSchema)this.xsdSchemas.get(fileName);
        }
        return null;
    }

    private void initMessageReceiverHandlerAdapter() {
        try {
            try {
                this.messageReceiverHandlerAdapter = (WebServiceMessageReceiverHandlerAdapter)this.getWebApplicationContext().getBean(this.getMessageReceiverHandlerAdapterBeanName(), WebServiceMessageReceiverHandlerAdapter.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.messageReceiverHandlerAdapter = new WebServiceMessageReceiverHandlerAdapter();
            }
            this.initWebServiceMessageFactory();
            this.messageReceiverHandlerAdapter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize WebServiceMessageReceiverHandlerAdapter", (Throwable)ex);
        }
    }

    private void initWebServiceMessageFactory() {
        WebServiceMessageFactory messageFactory;
        block2: {
            try {
                messageFactory = (WebServiceMessageFactory)this.getWebApplicationContext().getBean(this.getMessageFactoryBeanName(), WebServiceMessageFactory.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                messageFactory = (WebServiceMessageFactory)this.defaultStrategiesHelper.getDefaultStrategy(WebServiceMessageFactory.class, (ApplicationContext)this.getWebApplicationContext());
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("No WebServiceMessageFactory found in servlet '" + this.getServletName() + "': using default"));
            }
        }
        this.messageReceiverHandlerAdapter.setMessageFactory(messageFactory);
    }

    private void initWsdlDefinitionHandlerAdapter() {
        try {
            try {
                this.wsdlDefinitionHandlerAdapter = (WsdlDefinitionHandlerAdapter)((Object)this.getWebApplicationContext().getBean(this.getWsdlDefinitionHandlerAdapterBeanName(), WsdlDefinitionHandlerAdapter.class));
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.wsdlDefinitionHandlerAdapter = new WsdlDefinitionHandlerAdapter();
            }
            this.wsdlDefinitionHandlerAdapter.setTransformLocations(this.isTransformWsdlLocations());
            this.wsdlDefinitionHandlerAdapter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize WsdlDefinitionHandlerAdapter", (Throwable)ex);
        }
    }

    private void initXsdSchemaHandlerAdapter() {
        try {
            try {
                this.xsdSchemaHandlerAdapter = (XsdSchemaHandlerAdapter)((Object)this.getWebApplicationContext().getBean(this.getXsdSchemaHandlerAdapterBeanName(), XsdSchemaHandlerAdapter.class));
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.xsdSchemaHandlerAdapter = new XsdSchemaHandlerAdapter();
            }
            if (this.xsdSchemaHandlerAdapter instanceof InitializingBean) {
                ((InitializingBean)this.xsdSchemaHandlerAdapter).afterPropertiesSet();
            }
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize XsdSchemaHandlerAdapter", (Throwable)ex);
        }
    }

    private void initMessageReceiver() {
        block3: {
            try {
                this.messageReceiver = (WebServiceMessageReceiver)this.getWebApplicationContext().getBean(this.getMessageReceiverBeanName(), WebServiceMessageReceiver.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.messageReceiver = (WebServiceMessageReceiver)this.defaultStrategiesHelper.getDefaultStrategy(WebServiceMessageReceiver.class, (ApplicationContext)this.getWebApplicationContext());
                if (this.messageReceiver instanceof BeanNameAware) {
                    ((BeanNameAware)this.messageReceiver).setBeanName(this.getServletName());
                }
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("No MessageDispatcher found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initWsdlDefinitions() {
        this.wsdlDefinitions = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)WsdlDefinition.class, (boolean)true, (boolean)false);
        if (this.logger.isDebugEnabled()) {
            Iterator iterator = this.wsdlDefinitions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String beanName = (String)entry.getKey();
                WsdlDefinition definition = (WsdlDefinition)entry.getValue();
                this.logger.debug((Object)("Published [" + definition + "] as " + beanName + WSDL_SUFFIX_NAME));
            }
        }
    }

    private void initXsdSchemas() {
        this.xsdSchemas = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)XsdSchema.class, (boolean)true, (boolean)false);
        if (this.logger.isDebugEnabled()) {
            Iterator iterator = this.xsdSchemas.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String beanName = (String)entry.getKey();
                XsdSchema schema = (XsdSchema)entry.getValue();
                this.logger.debug((Object)("Published [" + schema + "] as " + beanName + XSD_SUFFIX_NAME));
            }
        }
    }
}

