/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.builder;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.wsdl.wsdl11.builder.AbstractSoap11Wsdl4jDefinitionBuilder;
import org.springframework.ws.wsdl.wsdl11.builder.XsdSchemaHelper;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XsdBasedSoap11Wsdl4jDefinitionBuilder
extends AbstractSoap11Wsdl4jDefinitionBuilder
implements InitializingBean {
    public static final String DEFAULT_REQUEST_SUFFIX = "Request";
    public static final String DEFAULT_RESPONSE_SUFFIX = "Response";
    public static final String DEFAULT_FAULT_SUFFIX = "Fault";
    public static final String DEFAULT_SCHEMA_PREFIX = "schema";
    public static final String DEFAULT_PREFIX = "tns";
    public static final String SERVICE_SUFFIX = "Service";
    private Resource schemaResource;
    private XsdSchemaHelper schemaHelper;
    private String schemaLocation;
    private String targetNamespace;
    private String portTypeName;
    private String schemaPrefix = "schema";
    private String prefix = "tns";
    private String requestSuffix = "Request";
    private String responseSuffix = "Response";
    private String faultSuffix = "Fault";
    private boolean followIncludeImport = false;

    public void setRequestSuffix(String requestSuffix) {
        this.requestSuffix = requestSuffix;
    }

    public void setResponseSuffix(String responseSuffix) {
        this.responseSuffix = responseSuffix;
    }

    public void setFaultSuffix(String faultSuffix) {
        this.faultSuffix = faultSuffix;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setSchemaPrefix(String schemaPrefix) {
        this.schemaPrefix = schemaPrefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSchema(Resource schemaResource) {
        Assert.notNull((Object)schemaResource, (String)"'schema' must not be null");
        Assert.isTrue((boolean)schemaResource.exists(), (String)("schema \"" + schemaResource + "\" does not exit"));
        this.schemaResource = schemaResource;
    }

    public void setSchemaLocation(String schemaLocation) {
        Assert.hasLength((String)schemaLocation, (String)"'schemaLocation' must not be empty");
        this.schemaLocation = schemaLocation;
    }

    public void setFollowIncludeImport(boolean followIncludeImport) {
        this.followIncludeImport = followIncludeImport;
    }

    public final void afterPropertiesSet() throws IOException, ParserConfigurationException, SAXException {
        Assert.notNull((Object)this.schemaResource, (String)"'schema' is required");
        Assert.notNull((Object)this.portTypeName, (String)"'portTypeName' is required");
        this.schemaHelper = new XsdSchemaHelper(this.schemaResource);
        if (!StringUtils.hasLength((String)this.targetNamespace)) {
            this.targetNamespace = this.schemaHelper.getTargetNamespace();
        }
    }

    protected void populateDefinition(Definition definition) throws WSDLException {
        super.populateDefinition(definition);
        definition.setTargetNamespace(this.targetNamespace);
        definition.addNamespace(this.schemaPrefix, this.schemaHelper.getTargetNamespace());
        if (!this.targetNamespace.equals(this.schemaHelper.getTargetNamespace())) {
            definition.addNamespace(this.prefix, this.targetNamespace);
        }
    }

    protected void buildImports(Definition definition) throws WSDLException {
    }

    protected void buildTypes(Definition definition) throws WSDLException {
        Types types = definition.createTypes();
        Schema schema = (Schema)this.createExtension(Types.class, XsdSchemaHelper.SCHEMA_NAME);
        if (!StringUtils.hasLength((String)this.schemaLocation)) {
            schema.setElement(this.schemaHelper.getSchemaElement());
        } else {
            Document document;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.newDocument();
            }
            catch (ParserConfigurationException ex) {
                throw new WSDLException("PARSER_ERROR", "Could not create DocumentBuilder", (Throwable)ex);
            }
            Element importingSchemaElement = document.createElementNS(XsdSchemaHelper.SCHEMA_NAME.getNamespaceURI(), QNameUtils.toQualifiedName((QName)XsdSchemaHelper.SCHEMA_NAME));
            schema.setElement(importingSchemaElement);
            Element importElement = document.createElementNS(XsdSchemaHelper.IMPORT_NAME.getNamespaceURI(), QNameUtils.toQualifiedName((QName)XsdSchemaHelper.IMPORT_NAME));
            importingSchemaElement.appendChild(importElement);
            importElement.setAttribute("namespace", this.schemaHelper.getTargetNamespace());
            importElement.setAttribute("schemaLocation", this.schemaLocation);
        }
        types.addExtensibilityElement((ExtensibilityElement)schema);
        definition.setTypes(types);
    }

    protected void buildMessages(Definition definition) throws WSDLException {
        List elementDeclarations = this.schemaHelper.getElementDeclarations(this.followIncludeImport);
        Iterator iterator = elementDeclarations.iterator();
        while (iterator.hasNext()) {
            QName elementName = (QName)iterator.next();
            if (elementName == null || !this.isRequestMessage(elementName) && !this.isResponseMessage(elementName) && !this.isFaultMessage(elementName)) continue;
            if (definition.getPrefix(elementName.getNamespaceURI()) == null) {
                int i = 0;
                while (true) {
                    String prefix;
                    if (!StringUtils.hasLength((String)definition.getNamespace(prefix = this.schemaPrefix + Integer.toString(i)))) {
                        definition.addNamespace(prefix, elementName.getNamespaceURI());
                        break;
                    }
                    ++i;
                }
            }
            Message message = definition.createMessage();
            this.populateMessage(message, elementName);
            Part part = definition.createPart();
            this.populatePart(part, elementName);
            message.addPart(part);
            message.setUndefined(false);
            definition.addMessage(message);
        }
    }

    protected boolean isRequestMessage(QName name) {
        return name.getLocalPart().endsWith(this.requestSuffix);
    }

    protected boolean isResponseMessage(QName name) {
        return name.getLocalPart().endsWith(this.responseSuffix);
    }

    protected boolean isFaultMessage(QName name) {
        return name.getLocalPart().endsWith(this.faultSuffix);
    }

    protected void populateMessage(Message message, QName elementName) throws WSDLException {
        message.setQName(new QName(this.targetNamespace, elementName.getLocalPart()));
    }

    protected void populatePart(Part part, QName elementName) throws WSDLException {
        part.setElementName(elementName);
        part.setName(elementName.getLocalPart());
    }

    protected void buildPortTypes(Definition definition) throws WSDLException {
        PortType portType = definition.createPortType();
        this.populatePortType(portType);
        this.createOperations(definition, portType);
        portType.setUndefined(false);
        definition.addPortType(portType);
    }

    protected void populatePortType(PortType portType) throws WSDLException {
        portType.setQName(new QName(this.targetNamespace, this.portTypeName));
    }

    private void createOperations(Definition definition, PortType portType) throws WSDLException {
        Iterator messageIterator = definition.getMessages().values().iterator();
        while (messageIterator.hasNext()) {
            Message message = (Message)messageIterator.next();
            Iterator partIterator = message.getParts().values().iterator();
            while (partIterator.hasNext()) {
                Part part = (Part)partIterator.next();
                if (!this.isRequestMessage(part.getElementName())) continue;
                Message requestMessage = message;
                Message responseMessage = definition.getMessage(this.getResponseMessageName(requestMessage.getQName()));
                Message faultMessage = definition.getMessage(this.getFaultMessageName(requestMessage.getQName()));
                Operation operation = definition.createOperation();
                this.populateOperation(operation, requestMessage, responseMessage);
                if (requestMessage != null) {
                    Input input = definition.createInput();
                    input.setMessage(requestMessage);
                    input.setName(requestMessage.getQName().getLocalPart());
                    operation.setInput(input);
                }
                if (responseMessage != null) {
                    Output output = definition.createOutput();
                    output.setMessage(responseMessage);
                    output.setName(responseMessage.getQName().getLocalPart());
                    operation.setOutput(output);
                }
                if (faultMessage != null) {
                    Fault fault = definition.createFault();
                    fault.setMessage(faultMessage);
                    fault.setName(faultMessage.getQName().getLocalPart());
                    operation.addFault(fault);
                }
                if (requestMessage != null && responseMessage != null) {
                    operation.setStyle(OperationType.REQUEST_RESPONSE);
                } else if (requestMessage != null && responseMessage == null) {
                    operation.setStyle(OperationType.ONE_WAY);
                } else if (requestMessage == null && responseMessage != null) {
                    operation.setStyle(OperationType.NOTIFICATION);
                }
                operation.setUndefined(false);
                portType.addOperation(operation);
            }
        }
    }

    protected QName getResponseMessageName(QName requestMessageName) {
        String localPart = requestMessageName.getLocalPart();
        if (localPart.endsWith(this.requestSuffix)) {
            String prefix = localPart.substring(0, localPart.length() - this.requestSuffix.length());
            return new QName(requestMessageName.getNamespaceURI(), prefix + this.responseSuffix);
        }
        return null;
    }

    protected QName getFaultMessageName(QName requestMessageName) {
        String localPart = requestMessageName.getLocalPart();
        if (localPart.endsWith(this.requestSuffix)) {
            String prefix = localPart.substring(0, localPart.length() - this.requestSuffix.length());
            return new QName(requestMessageName.getNamespaceURI(), prefix + this.faultSuffix);
        }
        return null;
    }

    protected void populateOperation(Operation operation, Message requestMessage, Message responseMessage) throws WSDLException {
        String localPart = requestMessage.getQName().getLocalPart();
        String operationName = null;
        if (localPart.endsWith(this.requestSuffix)) {
            operationName = localPart.substring(0, localPart.length() - this.requestSuffix.length());
        } else {
            localPart = responseMessage.getQName().getLocalPart();
            if (localPart.endsWith(this.responseSuffix)) {
                operationName = localPart.substring(0, localPart.length() - this.responseSuffix.length());
            }
        }
        operation.setName(operationName);
    }

    protected void populateService(Service service) throws WSDLException {
        service.setQName(new QName(this.targetNamespace, this.portTypeName + SERVICE_SUFFIX));
    }
}

