/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.sax.SaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XsdSchemaHelper {
    private static final Log logger = LogFactory.getLog((Class)XsdSchemaHelper.class);
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    static final QName SCHEMA_NAME = QNameUtils.createQName((String)"http://www.w3.org/2001/XMLSchema", (String)"schema", (String)"xsd");
    static final QName ELEMENT_NAME = QNameUtils.createQName((String)"http://www.w3.org/2001/XMLSchema", (String)"element", (String)"xsd");
    static final QName INCLUDE_NAME = QNameUtils.createQName((String)"http://www.w3.org/2001/XMLSchema", (String)"include", (String)"xsd");
    static final QName IMPORT_NAME = QNameUtils.createQName((String)"http://www.w3.org/2001/XMLSchema", (String)"import", (String)"xsd");
    private final Resource schemaResource;
    private final Element schemaElement;
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public XsdSchemaHelper(Resource schemaResource) throws ParserConfigurationException, IOException, SAXException {
        Assert.notNull((Object)schemaResource, (String)"schema must not be empty or null");
        Assert.isTrue((boolean)schemaResource.exists(), (String)("schema \"" + schemaResource + "\" does not exit"));
        this.schemaResource = schemaResource;
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document schemaDocument = documentBuilder.parse(SaxUtils.createInputSource((Resource)schemaResource));
        this.schemaElement = schemaDocument.getDocumentElement();
        Assert.isTrue((boolean)SCHEMA_NAME.getLocalPart().equals(this.schemaElement.getLocalName()), (String)("schema document root element has invalid local name : [" + this.schemaElement.getLocalName() + "] instead of [schema]"));
        Assert.isTrue((boolean)SCHEMA_NAME.getNamespaceURI().equals(this.schemaElement.getNamespaceURI()), (String)("schema document root element has invalid namespace uri: [" + this.schemaElement.getNamespaceURI() + "] instead of [" + SCHEMA_NAME.getNamespaceURI() + "]"));
        Assert.hasLength((String)this.getTargetNamespace(), (String)("schema [" + schemaResource + "] has no targetNamespace"));
    }

    public String getTargetNamespace() {
        return this.schemaElement.getAttribute("targetNamespace");
    }

    public Element getSchemaElement() {
        return this.schemaElement;
    }

    public List getElementDeclarations(boolean followIncludeImport) {
        ArrayList declarations = new ArrayList();
        this.getElementDeclarationsInternal(declarations, followIncludeImport);
        return declarations;
    }

    private void getElementDeclarationsInternal(List declarations, boolean followIncludeImport) {
        NodeList children = this.schemaElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String schemaLocation;
            if (children.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)children.item(i);
            QName childName = QNameUtils.getQNameForNode((Node)childElement);
            if (ELEMENT_NAME.equals(childName)) {
                declarations.add(this.getElementName(childElement));
                continue;
            }
            if (!followIncludeImport || !INCLUDE_NAME.equals(childName) && !IMPORT_NAME.equals(childName) || !StringUtils.hasLength((String)(schemaLocation = childElement.getAttribute("schemaLocation")))) continue;
            try {
                Resource resource = this.schemaResource.createRelative(schemaLocation);
                if (resource.exists()) {
                    XsdSchemaHelper helper = new XsdSchemaHelper(resource);
                    helper.getElementDeclarationsInternal(declarations, followIncludeImport);
                    continue;
                }
                logger.warn((Object)("Imported/Includes schema with location " + schemaLocation + " does not exist"));
                continue;
            }
            catch (Exception ex) {
                logger.warn((Object)ex);
            }
        }
    }

    private QName getElementName(Element element) {
        String attributeValue = element.getAttribute("name");
        return StringUtils.hasLength((String)attributeValue) ? new QName(this.getTargetNamespace(), attributeValue) : null;
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
    }
}

