/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABResultSetMetaData;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.ABTypes;
import Altibase.jdbc.driver.BindMeta;
import Altibase.jdbc.driver.Blob;
import Altibase.jdbc.driver.Clob;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;

class ABParameterMetaData
extends ABResultSetMetaData
implements ParameterMetaData,
ABTypes,
SQLStates {
    static final long serialVersionUID = 1L;
    private int mBatchUpdateCount = 0;

    ABParameterMetaData(ABStatement stmt, int params) throws SQLException {
        super(stmt);
        super.set(0, new int[1]);
        for (int i = 1; i <= params; ++i) {
            this.allocAndAddMetaColumn(new BindMeta(i));
        }
        this.mExecuteReady = true;
    }

    void addBatch() throws SQLException {
        this.mCurrentSize = this.mCurrentPos = (short)(this.mCurrentPos + 1);
        ++this.mBatchUpdateCount;
    }

    void allocBatchResult() {
        super.set(0, new int[this.mBatchUpdateCount]);
        this.mBatchUpdateCount = 0;
    }

    void clearArray() throws SQLException {
        super.clearArray();
        this.mBatchUpdateCount = 0;
    }

    final Blob getBlob(int p) throws SQLException {
        BindMeta bm = this.getMetaColumn(p);
        ex.test(bm.getDataType() != 31, (short)103);
        return bm.blobValue(this.mCurrentPos);
    }

    final byte getByte(int p) throws SQLException {
        return this.getMetaColumn(p).byteValue(this.mCurrentPos);
    }

    final byte[] getBytes(int p) throws SQLException {
        return this.getMetaColumn(p).bytesValue(this.mCurrentPos);
    }

    final Clob getClob(int p) throws SQLException {
        BindMeta bm = this.getMetaColumn(p);
        ex.test(bm.getDataType() != 41, (short)103);
        return bm.clobValue(this.mCurrentPos);
    }

    final Date getDate(int p) throws SQLException {
        return this.getMetaColumn(p).getDate(this.mCurrentPos);
    }

    final double getDouble(int p) throws SQLException {
        return this.getMetaColumn(p).getDouble(this.mCurrentPos);
    }

    final float getFloat(int p) throws SQLException {
        return this.getMetaColumn(p).getFloat(this.mCurrentPos);
    }

    final int getInt(int p) throws SQLException {
        return this.getMetaColumn(p).getInt(this.mCurrentPos);
    }

    final long getLong(int p) throws SQLException {
        return this.getMetaColumn(p).getLong(this.mCurrentPos);
    }

    final Object getObject(int p) throws SQLException {
        return this.getMetaColumn(p).getObject(this.mCurrentPos);
    }

    public String getParameterClassName(int p) throws SQLException {
        return ((BindMeta)super.get(p)).getClassName();
    }

    public int getParameterCount() throws SQLException {
        return super.getColumnCount();
    }

    public int getParameterMode(int p) throws SQLException {
        return ((BindMeta)super.get(p)).getInOutType();
    }

    public int getParameterType(int p) throws SQLException {
        return ((BindMeta)super.get(p)).getType();
    }

    public String getParameterTypeName(int p) throws SQLException {
        return ((BindMeta)super.get(p)).getTypeName();
    }

    final int[] getResultArray(int size) throws SQLException {
        int[] res = new int[this.mCurrentSize];
        System.arraycopy((int[])this.get(0), 0, res, 0, size);
        while (size < this.mCurrentSize) {
            res[size] = -3;
            ++size;
        }
        return res;
    }

    final short getShort(int p) throws SQLException {
        return this.getMetaColumn(p).getShort(this.mCurrentPos);
    }

    final String getString(int p) throws SQLException {
        return this.getMetaColumn(p).getString(this.mCurrentPos);
    }

    final Time getTime(int p) throws SQLException {
        return this.getMetaColumn(p).getTime(this.mCurrentPos);
    }

    final Timestamp getTimestamp(int p) throws SQLException {
        return this.getMetaColumn(p).getTimestamp(this.mCurrentPos);
    }

    private final BindMeta param(int p, int type) throws SQLException {
        return this.param(p, type, 0, 0, 0);
    }

    private final BindMeta param(int aColNo, int aType, int aPrecision, int aDataPrecision, int aScale) throws SQLException {
        BindMeta sBindMeta = this.getMetaColumn(aColNo);
        if (sBindMeta.getDataType() != aType || sBindMeta.getPrecision() != aPrecision) {
            ex.test(this.mCurrentSize > 1, (short)89, SQLStates.mFixmsg[15]);
            this.mExecuteReady |= sBindMeta.setDataType(aType, aPrecision, aDataPrecision);
            sBindMeta.reAlloc();
            sBindMeta.setEncoder(this.mStatement.getEncoder());
            this.mCurrentSize = sBindMeta.mSize = 1;
        } else {
            sBindMeta.setEncoder(this.mStatement.getEncoder());
        }
        this.mChangedBindInfo |= sBindMeta.mIsBindInfoParam;
        this.mExecuteReady |= sBindMeta.modeInput();
        return sBindMeta;
    }

    final void set(int p, BigDecimal x) throws SQLException {
        this.param(p, 2, 38, 38, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, Blob b) throws SQLException {
        BindMeta bm = this.param(p, 31, 19, 19, 0);
        bm.set((int)this.mCurrentPos, b);
        if (b.link() != null) {
            this.mLobUpdater.put(new Integer(p), b);
        }
    }

    final void set(int p, Clob c) throws SQLException {
        BindMeta bm = this.param(p, 41, 19, 19, 0);
        bm.set((int)this.mCurrentPos, c);
        this.mLobUpdater.put(new Integer(p), c);
    }

    final void set(int p, boolean x) throws SQLException {
        if (x) {
            this.param(p, 5, 5, 5, 0).set((int)this.mCurrentPos, (short)1);
        } else {
            this.param(p, 5, 5, 5, 0).set((int)this.mCurrentPos, (short)0);
        }
    }

    final void set(int p, ByteBuffer x) throws SQLException {
        this.param(p, -2, x.limit(), x.limit(), 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, Date x) throws SQLException {
        this.param(p, 9, 30, 30, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, double x) throws SQLException {
        this.param(p, 8, 15, 15, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, float x) throws SQLException {
        this.param(p, 7, 7, 7, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, int x) throws SQLException {
        this.param(p, 4, 10, 10, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, long x) throws SQLException {
        this.param(p, -5, 19, 19, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, short x) throws SQLException {
        this.param(p, 5, 5, 5, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, String x) throws SQLException {
        int sBytesOfString = x == null ? 0 : x.length() * this.mStatement.getEncoder().maxBytesPerChar();
        this.param(p, 1, 32000, sBytesOfString, 0).set((int)this.mCurrentPos, x);
    }

    final void setBitSet(int p, String x) throws SQLException {
        this.param(p, -8, x.length(), x.length(), 0).setBitSet((int)this.mCurrentPos, x);
    }

    final void setBitSet(int p, byte[] x) throws SQLException {
        this.param(p, -8, x.length * 8, x.length * 8, 0).setBitSet((int)this.mCurrentPos, x);
    }

    final void set(int p, BitSet x, int scale) throws SQLException {
        this.param(p, -8, x.size(), x.size(), 0).set(this.mCurrentPos, x, scale);
    }

    final void set(int p, Time x) throws SQLException {
        this.param(p, 9, 30, 30, 0).set((int)this.mCurrentPos, x);
    }

    final void set(int p, Timestamp x) throws SQLException {
        this.param(p, 9, 30, 30, 0).set((int)this.mCurrentPos, x);
    }

    final void setAltibaseBytes(int p, ByteBuffer x) throws SQLException {
        this.param(p, 20001, x.limit(), x.limit(), 0).set((int)this.mCurrentPos, x);
    }

    final void setNibble(int p, ByteBuffer x) throws SQLException {
        this.param(p, 20002, x.limit() << 1, x.limit() << 1, 0).set((int)this.mCurrentPos, x);
    }

    final void setNull(int p, int type) throws SQLException {
        int mtType = this.getMetaColumn(p).getMTType(type);
        this.param(p, mtType, 4, 4, 0).setNull(this.mCurrentPos);
        if (mtType == 31 || mtType == 41) {
            this.mLobUpdater.remove(new Integer(p));
        }
    }

    final void setUpdateCount(long count, int pos) throws SQLException {
        if (pos < ((int[])this.get(0)).length) {
            ((int[])this.get((int)0))[pos] = (int)count;
        }
    }

    final boolean write(cmp chn) throws SQLException {
        boolean next;
        boolean bl = next = this.mCurrentPos < this.mCurrentSize || this.mCurrentPos == 0;
        if (next) {
            for (int i = 1; i < this.size(); ++i) {
                this.getMetaColumn(i).writeOutParamData(chn, this.getStmtID(), this.mCurrentPos);
            }
            this.mCurrentPos = (short)(this.mCurrentPos + 1);
        }
        return next;
    }
}

