/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABString;
import Altibase.jdbc.driver.ABTypes;
import Altibase.jdbc.driver.BitSet;
import Altibase.jdbc.driver.Blob;
import Altibase.jdbc.driver.Clob;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.cmb;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import Altibase.jdbc.driver.mtdDate;
import Altibase.jdbc.driver.mtdInterval;
import Altibase.jdbc.driver.mtdNumeric;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

class BindMeta
implements cm,
ABTypes,
SQLStates,
Cloneable {
    static final byte NULABLE = 1;
    static final byte P_KEY = 64;
    static final Object NULL_OBJ = new Object();
    short mColumnNo;
    short mSize;
    int mDataType;
    int mLanguage;
    int mPrecision;
    int mDataPrecision;
    int mScale;
    byte mInOutType;
    byte mNullableFlag;
    byte mArguments;
    String mColumnName;
    ArrayList mColumnData;
    boolean mIsBindInfoParam;
    ABEncoder mEncoder;
    static /* synthetic */ Class class$Altibase$jdbc$driver$mtdNumeric;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$Altibase$jdbc$driver$ABString;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$nio$ByteBuffer;
    static /* synthetic */ Class class$Altibase$jdbc$driver$Blob;
    static /* synthetic */ Class class$Altibase$jdbc$driver$mtdDate;
    static /* synthetic */ Class class$Altibase$jdbc$driver$mtdInterval;
    static /* synthetic */ Class class$Altibase$jdbc$driver$BitSet;
    static /* synthetic */ Class class$Altibase$jdbc$driver$Clob;
    static /* synthetic */ Class class$java$sql$Timestamp;

    BindMeta(int idx) {
        this.mColumnNo = (short)idx;
        this.mDataType = 0;
        this.mLanguage = 0;
        this.mPrecision = 0;
        this.mScale = 0;
        this.mNullableFlag = 1;
        this.mInOutType = 0;
        this.mArguments = 0;
        this.mDataPrecision = 0;
        this.mColumnName = "";
        this.mColumnData = new ArrayList();
        this.mIsBindInfoParam = true;
        this.mSize = 0;
        this.mEncoder = null;
    }

    boolean after(cmp chn, short row) throws SQLException {
        switch (this.mDataType) {
            case 31: 
            case 41: {
                return true;
            }
        }
        return false;
    }

    boolean writeBindProtocol(cmp chn, int aStmtId) throws SQLException {
        if (this.mIsBindInfoParam) {
            cmb cbw = chn.next((byte)23);
            cbw.putInt(aStmtId);
            cbw.putShort(this.mColumnNo);
            cbw.putInt(this.mDataType);
            cbw.putInt(this.mLanguage);
            cbw.putByte(this.mArguments);
            cbw.putInt(this.mPrecision);
            cbw.putInt(this.mScale);
            cbw.putByte(this.mInOutType);
            this.mIsBindInfoParam = false;
            return true;
        }
        return false;
    }

    Blob blobValue(int row) throws SQLException {
        switch (this.mDataType) {
            case 31: {
                ((Blob)this.mColumnData.get(row)).open();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return (Blob)this.mColumnData.get(row);
    }

    public boolean boolValue(int row) throws SQLException {
        boolean ret = false;
        switch (this.mDataType) {
            case 2: {
                ret = ((mtdNumeric)this.getData(row, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).intValue() > 0;
                break;
            }
            case 8: {
                ret = (Double)this.getData(row, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double) > 0.0;
                break;
            }
            case 7: {
                ret = ((Float)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue() > 0.0f;
                break;
            }
            case 4: {
                ret = (Integer)this.getData(row, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer) > 0;
                break;
            }
            case -5: {
                ret = (Long)this.getData(row, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long) > 0L;
                break;
            }
            case 5: {
                ret = (Short)this.getData(row, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short) > 0;
                break;
            }
            case 1: 
            case 12: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).isTrue();
                break;
            }
            case 16: {
                ret = (Byte)this.getData(row, class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte) > 0;
            }
        }
        return ret;
    }

    byte[] bytesValue(int row) throws SQLException {
        byte[] ret = null;
        switch (this.mDataType) {
            case -2: 
            case 20001: 
            case 20002: {
                ByteBuffer bb = (ByteBuffer)this.getData(row, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
                if (bb.limit() <= 0) break;
                ret = new byte[bb.limit()];
                bb.get(ret);
                bb.position(0);
                break;
            }
            case 1: 
            case 12: {
                ABString s = (ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString);
                if (s.isNull()) break;
                ret = s.getBytes();
                break;
            }
            case 31: {
                Blob lob = (Blob)this.getData(row, class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob);
                if (lob == null) break;
                lob.open();
                ret = lob.getBytes(1L, (int)lob.length());
                break;
            }
            default: {
                ex.exception((short)37);
            }
        }
        return ret;
    }

    byte byteValue(int row) throws SQLException {
        short ret = 0;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                short v = this.dataShort(row);
                ret = (byte)v;
                ex.test(ret != v, (short)37);
                break;
            }
            case 4: {
                int v = this.dataInt(row);
                ret = (byte)v;
                ex.test(ret != v, (short)37);
                break;
            }
            case -5: {
                long v = this.dataLong(row);
                ret = (byte)v;
                ex.test((long)ret != v, (short)37);
                break;
            }
            case 8: {
                double v = this.dataDouble(row);
                ex.test(v > 127.0 || v < -128.0, (short)37);
                ret = (byte)v;
                break;
            }
            case 7: {
                float v = this.dataFloat(row);
                ex.test(v > 127.0f || v < -128.0f, (short)37);
                ret = (byte)v;
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).byteValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).byteValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
            }
            default: {
                ex.exception((short)19);
            }
        }
        return (byte)ret;
    }

    Clob clobValue(int row) throws SQLException {
        return (Clob)this.mColumnData.get(row);
    }

    protected final byte dataByte(int row) throws SQLException {
        byte sValue = (Byte)this.getData(row, class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte);
        if (this.isnull(sValue)) {
            sValue = 0;
        }
        return sValue;
    }

    final double dataDouble(int row) throws SQLException {
        double sValue = (Double)this.getData(row, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double);
        if (this.isnull(sValue)) {
            sValue = 0.0;
        }
        return sValue;
    }

    final float dataFloat(int row) throws SQLException {
        float sValue = ((Float)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue();
        if (this.isnull(sValue)) {
            sValue = 0.0f;
        }
        return sValue;
    }

    final int dataInt(int row) throws SQLException {
        int sValue = (Integer)this.getData(row, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer);
        if (this.isnull(sValue)) {
            sValue = 0;
        }
        return sValue;
    }

    final long dataLong(int row) throws SQLException {
        long sValue = (Long)this.getData(row, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long);
        if (this.isnull(sValue)) {
            sValue = 0L;
        }
        return sValue;
    }

    final short dataShort(int row) throws SQLException {
        short sValue = (Short)this.getData(row, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short);
        if (this.isnull(sValue)) {
            sValue = 0;
        }
        return sValue;
    }

    final byte getArguments() {
        return this.mArguments;
    }

    BigDecimal getBigDecimal(int row) throws SQLException {
        BigDecimal ret = null;
        switch (this.mDataType) {
            case 2: 
            case 6: 
            case 10002: {
                ret = ((mtdNumeric)this.getData(row, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).getBigDecimal();
                break;
            }
            case 8: {
                ret = new BigDecimal((Double)this.getData(row, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double));
                break;
            }
            case 7: {
                ret = new BigDecimal(((Float)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue());
                break;
            }
            case 4: {
                ret = new BigDecimal((double)((Integer)this.getData(row, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer)).intValue());
                break;
            }
            case -5: {
                ret = new BigDecimal((double)((Long)this.getData(row, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long)).longValue());
                break;
            }
            case 5: {
                ret = new BigDecimal((double)((Short)this.getData(row, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short)).shortValue());
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).getNumeric();
                    break;
                }
                catch (Exception e) {
                    ex.exception((short)42, e.getMessage());
                }
            }
            case -999: 
            case 0: {
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    private void setData(int index, Object data) {
        if (this.mColumnData.size() <= index) {
            for (int i = this.mColumnData.size(); i <= index; ++i) {
                this.mColumnData.add(NULL_OBJ);
            }
        }
        this.mColumnData.set(index, data);
    }

    private Object getData(int index, Class defaultObjType) throws SQLException {
        Object ret = null;
        ex.test(index < 0, (short)100);
        if (index < this.mColumnData.size()) {
            ret = this.mColumnData.get(index);
        }
        if (ret == null || ret == NULL_OBJ) {
            if (defaultObjType == (class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                ret = new Byte(-128);
            } else if (defaultObjType == (class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short)) {
                ret = new Short(Short.MIN_VALUE);
            } else if (defaultObjType == (class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                ret = new Integer(Integer.MIN_VALUE);
            } else if (defaultObjType == (class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long)) {
                ret = new Long(Long.MIN_VALUE);
            } else if (defaultObjType == (class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)) {
                ret = new Float(Float.NaN);
            } else if (defaultObjType == (class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double)) {
                ret = new Double(Double.NaN);
            } else if (defaultObjType == (class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)) {
                try {
                    ret = new ABString(this.mEncoder, this.mDataPrecision);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if (defaultObjType == (class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer)) {
                ret = ByteBuffer.allocate(this.mPrecision);
            } else if (defaultObjType == (class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)) {
                try {
                    ret = new mtdDate();
                }
                catch (SQLException e) {}
            } else if (defaultObjType == (class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)) {
                ret = new mtdInterval();
            } else if (defaultObjType == (class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)) {
                try {
                    ret = new mtdNumeric(this.mPrecision);
                }
                catch (SQLException e) {}
            } else if (defaultObjType == (class$Altibase$jdbc$driver$BitSet == null ? (class$Altibase$jdbc$driver$BitSet = BindMeta.class$("Altibase.jdbc.driver.BitSet")) : class$Altibase$jdbc$driver$BitSet)) {
                ret = new BitSet(this.mPrecision);
            } else if (defaultObjType == (class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob)) {
                ret = new Blob();
            } else if (defaultObjType == (class$Altibase$jdbc$driver$Clob == null ? (class$Altibase$jdbc$driver$Clob = BindMeta.class$("Altibase.jdbc.driver.Clob")) : class$Altibase$jdbc$driver$Clob)) {
                ret = new Clob();
            } else if (defaultObjType == (class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)) {
                try {
                    ret = new mtdDate().sqlTimestamp();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            this.setData(index, ret);
        }
        return ret;
    }

    final String getClassName() throws SQLException {
        String ret = "Object";
        switch (this.mDataType) {
            case 16: {
                ret = "java.lang.Boolean";
                break;
            }
            case 5: {
                ret = "java.lang.Short";
                break;
            }
            case 4: {
                ret = "java.lang.Integer";
                break;
            }
            case -5: {
                ret = "java.lang.Long";
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = "java.math.BigDecimal";
                break;
            }
            case 7: {
                ret = "java.lang.Float";
                break;
            }
            case 10: {
                ret = "Altibase.jdbc.driver.mtdInterval";
                break;
            }
            case 8: {
                ret = "java.lang.Double";
                break;
            }
            case -2: 
            case 20001: {
                ret = "byte";
                break;
            }
            case 30: 
            case 20002: {
                ret = "byte";
                break;
            }
            case 31: {
                ret = "java.sql.Blob";
                break;
            }
            case 1: 
            case 12: 
            case 40: {
                ret = "java.lang.String";
                break;
            }
            case 41: {
                ret = "java.sql.Clob";
                break;
            }
            case 9: {
                ret = "java.sql.Timestamp";
                break;
            }
            case 10003: {
                ret = "Altibase.jdbc.driver.Geometry";
                break;
            }
            case 10001: {
                ret = "Altibase.jdbc.driver.GeometryList";
                break;
            }
            case 30001: {
                ret = "File";
                break;
            }
            case 0: {
                ret = "null";
                break;
            }
            case -8: 
            case -7: {
                ret = "java.unit.BitSet";
            }
        }
        return ret;
    }

    final int getDataType() {
        return this.mDataType;
    }

    Date getDate(int row) throws SQLException {
        Date ret = null;
        switch (this.mDataType) {
            case 0: {
                break;
            }
            case 9: {
                long time = ((Timestamp)this.getData(row, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BindMeta.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)).getTime();
                if (time == Long.MIN_VALUE) break;
                ret = new Date(time);
                break;
            }
            case 1: 
            case 12: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).dateValue();
                if (ret == null) break;
                ret = (Date)ret.clone();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    final int getDisplaySize() {
        switch (this.mDataType) {
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 20;
            }
            case 9: {
                return 24;
            }
        }
        return this.mPrecision;
    }

    double getDouble(int row) throws SQLException {
        double ret = 0.0;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                ret = this.dataShort(row);
                break;
            }
            case 4: {
                ret = this.dataInt(row);
                break;
            }
            case -5: {
                ret = this.dataLong(row);
                break;
            }
            case 8: {
                ret = this.dataDouble(row);
                break;
            }
            case 7: {
                ret = this.dataFloat(row);
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).doubleValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).doubleValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
                break;
            }
            case 10: {
                ret = ((mtdInterval)this.getData(row, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)).getDays();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    float getFloat(int row) throws SQLException {
        float ret = 0.0f;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                ret = this.dataShort(row);
                break;
            }
            case 4: {
                ret = this.dataInt(row);
                break;
            }
            case -5: {
                ret = this.dataLong(row);
                break;
            }
            case 8: {
                double v = this.dataDouble(row);
                ex.test(v > 3.4028234663852886E38, (short)37);
                ret = (float)v;
                break;
            }
            case 7: {
                ret = this.dataFloat(row);
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).floatValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    final short getId() {
        return this.mColumnNo;
    }

    final byte getInOutType() {
        return this.mInOutType;
    }

    int getInt(int row) throws SQLException {
        int ret = 0;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                ret = this.dataShort(row);
                break;
            }
            case 4: {
                ret = this.dataInt(row);
                break;
            }
            case -5: {
                long v = this.dataLong(row);
                ret = (int)v;
                ex.test(v != v, (short)35);
                break;
            }
            case 8: {
                ret = (int)this.dataDouble(row);
                break;
            }
            case 7: {
                ret = (int)this.dataFloat(row);
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).intValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).intValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    String getLable() {
        return this.mColumnName;
    }

    final int getLanguage() {
        return this.mLanguage;
    }

    long getLong(int row) throws SQLException {
        long ret = 0L;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                ret = this.dataShort(row);
                break;
            }
            case 4: {
                ret = this.dataInt(row);
                break;
            }
            case -5: {
                ret = this.dataLong(row);
                break;
            }
            case 8: {
                ret = (long)this.dataDouble(row);
                break;
            }
            case 7: {
                ret = (long)this.dataFloat(row);
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).longValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).longValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
                break;
            }
            case 10: {
                ret = ((mtdInterval)this.getData(row, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)).getMilliseconds();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    String getName() {
        int dot = this.mColumnName.lastIndexOf(46);
        if (dot > 0) {
            return this.mColumnName.substring(dot);
        }
        return this.mColumnName;
    }

    final byte getNullableFlag() {
        return this.mNullableFlag;
    }

    final Object getObject(int row) throws SQLException {
        Object ret = null;
        switch (this.mDataType) {
            case 16: {
                byte byteValue = (Byte)this.getData(row, class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte);
                if (this.isnull(byteValue)) {
                    ret = Boolean.FALSE;
                    break;
                }
                ret = new Boolean(byteValue != 0);
                break;
            }
            case 5: {
                Short shortValue = (Short)this.getData(row, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short);
                if (this.isnull(shortValue)) break;
                ret = shortValue;
                break;
            }
            case 4: {
                Integer intValue = (Integer)this.getData(row, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer);
                if (this.isnull(intValue)) break;
                ret = intValue;
                break;
            }
            case -5: {
                Long longValue = (Long)this.getData(row, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long);
                if (this.isnull(longValue)) break;
                ret = longValue;
                break;
            }
            case 1: 
            case 12: 
            case 40: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).toString();
                break;
            }
            case -2: 
            case 30: 
            case 20001: 
            case 20002: {
                ByteBuffer bb = (ByteBuffer)this.getData(row, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
                if (this.isnull(bb)) break;
                ret = new byte[bb.limit()];
                System.arraycopy(bb.array(), 0, ret, 0, bb.limit());
                break;
            }
            case 31: {
                ret = this.blobValue(row);
                break;
            }
            case 41: {
                ret = this.clobValue(row);
                break;
            }
            case 9: {
                mtdDate md = (mtdDate)this.getData(row, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate);
                if (md.isNull()) break;
                ret = md.clone();
                break;
            }
            case 7: {
                Float floatValue = (Float)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float);
                if (this.isnull(floatValue.floatValue())) break;
                ret = floatValue;
                break;
            }
            case 8: {
                Double doubleValue = (Double)this.getData(row, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double);
                if (this.isnull(doubleValue)) break;
                ret = doubleValue;
                break;
            }
            case 10: {
                mtdInterval sInterval = (mtdInterval)this.getData(row, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval);
                if (sInterval.isNull()) break;
                ret = sInterval;
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((mtdNumeric)this.getData(row, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).getObject();
                break;
            }
            case -8: 
            case -7: {
                ret = (BitSet)this.getData(row, class$Altibase$jdbc$driver$BitSet == null ? (class$Altibase$jdbc$driver$BitSet = BindMeta.class$("Altibase.jdbc.driver.BitSet")) : class$Altibase$jdbc$driver$BitSet);
            }
        }
        return ret;
    }

    final int getPrecision() {
        return this.mPrecision;
    }

    final int getScale() {
        return this.mScale;
    }

    short getShort(int row) throws SQLException {
        int ret = 0;
        switch (this.mDataType) {
            case 16: {
                ret = this.dataByte(row);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                ret = this.dataShort(row);
                break;
            }
            case 4: {
                int v = this.dataInt(row);
                ret = (short)v;
                ex.test(ret != v, (short)37);
                break;
            }
            case -5: {
                long v = this.dataLong(row);
                ret = (short)v;
                ex.test((long)ret != v, (short)37);
                break;
            }
            case 8: {
                double v = this.dataDouble(row);
                ex.test(v > 32767.0 || v < -32768.0, (short)37);
                ret = (short)v;
                break;
            }
            case 7: {
                float v = this.dataFloat(row);
                ex.test(v > 32767.0f || v < -32768.0f, (short)37);
                ret = (short)v;
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((Number)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).shortValue();
                break;
            }
            case 1: 
            case 12: {
                try {
                    ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).shortValue();
                }
                catch (NumberFormatException e) {
                    ex.exception((short)42);
                }
            }
            default: {
                ex.exception((short)19);
            }
        }
        return (short)ret;
    }

    final String getString(int rsx) throws SQLException {
        Object obj = this.getObject(rsx);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    String getTableName() {
        int dot = this.mColumnName.lastIndexOf(46);
        if (dot > 0) {
            return this.mColumnName.substring(0, dot);
        }
        return "";
    }

    Time getTime(int row) throws SQLException {
        Time ret = null;
        switch (this.mDataType) {
            case 0: {
                break;
            }
            case 9: {
                ret = ((mtdDate)this.getData(row, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).sqlTime();
                break;
            }
            case 1: 
            case 12: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).timeValue();
                if (ret == null) break;
                ret = (Time)ret.clone();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    Timestamp getTimestamp(int row) throws SQLException {
        Timestamp ret = null;
        switch (this.mDataType) {
            case 0: {
                break;
            }
            case 9: {
                ret = ((mtdDate)this.getData(row, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).sqlTimestamp();
                if (ret == null) break;
                ret = (Timestamp)ret.clone();
                break;
            }
            case 1: 
            case 12: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).timestampValue();
                if (ret == null) break;
                ret = (Timestamp)ret.clone();
                break;
            }
            default: {
                ex.exception((short)19);
            }
        }
        return ret;
    }

    Timestamp getTimeStamp(short row) throws SQLException {
        Timestamp ret = null;
        ret = ((mtdDate)this.getData(row, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).sqlTimestamp();
        if (ret != null) {
            ret = (Timestamp)ret.clone();
        }
        return ret;
    }

    final int getType() throws SQLException {
        int type = this.mDataType;
        switch (this.mDataType) {
            case -2: 
            case 20001: 
            case 20002: {
                type = -2;
                break;
            }
            case 30: {
                type = -3;
                break;
            }
            case 31: {
                type = 2004;
                break;
            }
            case 40: {
                type = 12;
                break;
            }
            case 41: {
                type = 2005;
                break;
            }
            case 9: {
                type = 93;
                break;
            }
            case 10: {
                type = 10;
                break;
            }
            case 10001: {
                type = 1111;
                break;
            }
            case 10002: {
                type = 2;
            }
        }
        return type;
    }

    String getTypeName() {
        String ret = "UNKNOWN";
        switch (this.mDataType) {
            case -5: {
                ret = "BIGINT";
                break;
            }
            case 30: 
            case 31: {
                ret = "BLOB";
                break;
            }
            case 40: 
            case 41: {
                ret = "CLOB";
                break;
            }
            case 1: {
                ret = "CHAR";
                break;
            }
            case 9: {
                ret = "DATE";
                break;
            }
            case 8: {
                ret = "DOUBLE";
                break;
            }
            case 6: {
                ret = "FLOAT";
                break;
            }
            case 10003: {
                ret = "GEOMETRY";
                break;
            }
            case 20001: {
                ret = "BYTE";
                break;
            }
            case -2: {
                ret = "BINARY";
                break;
            }
            case 20002: {
                ret = "NIBBLE";
                break;
            }
            case 4: {
                ret = "INTEGER";
                break;
            }
            case 10: {
                ret = "INTERVAL";
                break;
            }
            case 2: 
            case 10002: {
                ret = "NUMERIC";
                break;
            }
            case 7: {
                ret = "REAL";
                break;
            }
            case 5: {
                ret = "SMALLINT";
                break;
            }
            case 12: {
                ret = "VARCHAR";
                break;
            }
            case 30001: {
                ret = "FILE";
                break;
            }
            case -7: {
                ret = "BIT";
                break;
            }
            case -8: {
                ret = "VARBIT";
            }
        }
        return ret;
    }

    protected final boolean isnull(Buffer v) {
        return v.limit() == 0;
    }

    protected final boolean isnull(byte v) {
        return v == -128;
    }

    protected final boolean isnull(double v) {
        return Double.isNaN(v);
    }

    protected final boolean isnull(float v) {
        return Float.isNaN(v);
    }

    protected final boolean isnull(int v) {
        return v == Integer.MIN_VALUE;
    }

    protected final boolean isnull(long v) {
        return v == Long.MIN_VALUE;
    }

    protected final boolean isnull(short v) {
        return v == Short.MIN_VALUE;
    }

    final boolean isNull(int row) throws SQLException {
        boolean ret = true;
        switch (this.mDataType) {
            case 16: {
                ret = this.isnull((Byte)this.getData(row, class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte));
                break;
            }
            case 5: {
                ret = this.isnull((Short)this.getData(row, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short));
                break;
            }
            case 4: {
                ret = this.isnull((Integer)this.getData(row, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer));
                break;
            }
            case -5: {
                ret = this.isnull((Long)this.getData(row, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long));
                break;
            }
            case 7: {
                ret = this.isnull(((Float)this.getData(row, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue());
                break;
            }
            case 8: {
                ret = this.isnull((Double)this.getData(row, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double));
                break;
            }
            case 1: 
            case 12: 
            case 30: 
            case 40: {
                ret = ((ABString)this.getData(row, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).isNull();
                break;
            }
            case -2: 
            case 20001: 
            case 20002: {
                ret = this.isnull((ByteBuffer)this.getData(row, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer));
                break;
            }
            case 41: {
                ret = ((Clob)this.getData(row, class$Altibase$jdbc$driver$Clob == null ? (class$Altibase$jdbc$driver$Clob = BindMeta.class$("Altibase.jdbc.driver.Clob")) : class$Altibase$jdbc$driver$Clob)).isNull();
                break;
            }
            case 31: {
                ret = ((Blob)this.getData(row, class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob)).isNull();
                break;
            }
            case 9: {
                ret = ((mtdDate)this.getData(row, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).isNull();
                break;
            }
            case 10: {
                ret = ((mtdInterval)this.getData(row, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)).isNull();
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                ret = ((mtdNumeric)this.getData(row, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).isNull();
            }
        }
        return ret;
    }

    int isNullable() throws SQLException {
        return this.mNullableFlag;
    }

    boolean isWritable() throws SQLException {
        switch (this.mInOutType) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    final boolean modeInput() {
        block0 : switch (this.mInOutType) {
            case 0: {
                switch (this.mDataType) {
                    case 31: 
                    case 41: {
                        this.mInOutType = (byte)4;
                        this.mIsBindInfoParam = true;
                        break block0;
                    }
                }
                this.mInOutType = 1;
                this.mIsBindInfoParam = true;
                break;
            }
            case 4: {
                switch (this.mDataType) {
                    case 31: 
                    case 41: {
                        break block0;
                    }
                }
                this.mInOutType = (byte)2;
                this.mIsBindInfoParam = true;
            }
        }
        return this.mIsBindInfoParam;
    }

    final boolean modeOut() {
        switch (this.mInOutType) {
            case 0: {
                this.mInOutType = (byte)4;
                this.mIsBindInfoParam = true;
                break;
            }
            case 1: {
                this.mInOutType = (byte)2;
                this.mIsBindInfoParam = true;
            }
        }
        return this.mIsBindInfoParam;
    }

    final void readDataFromCM(cmp chn, int aRowNo) throws SQLException {
        byte any = chn.getAny();
        cmb cbr = chn.remain();
        block0 : switch (any) {
            case 0: 
            case 1: {
                this.setNull(aRowNo);
                break;
            }
            case 2: 
            case 3: {
                this.set(aRowNo, cbr.get());
                break;
            }
            case 4: 
            case 5: {
                this.set(aRowNo, cbr.shortValue());
                break;
            }
            case 6: 
            case 7: {
                this.set(aRowNo, cbr.intValue());
                break;
            }
            case 8: 
            case 9: {
                this.set(aRowNo, cbr.longValue());
                break;
            }
            case 10: {
                this.set(aRowNo, cbr.floatValue());
                break;
            }
            case 11: {
                this.set(aRowNo, cbr.doubleValue());
                break;
            }
            case 12: {
                ((mtdDate)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).read(chn);
                break;
            }
            case 13: {
                ((mtdInterval)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)).read(chn);
                break;
            }
            case 14: {
                ((mtdNumeric)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).read(chn);
                break;
            }
            case 15: 
            case 17: {
                switch (this.mDataType) {
                    case 1: 
                    case 12: 
                    case 40: {
                        ((ABString)this.getData(aRowNo, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).read(chn);
                        break block0;
                    }
                    case -2: 
                    case 30: 
                    case 20001: 
                    case 20002: {
                        chn.get((ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer));
                        break block0;
                    }
                }
                ex.exception((short)33);
                break;
            }
            case 16: 
            case 18: {
                switch (this.mDataType) {
                    case 1: 
                    case 12: 
                    case 40: {
                        ((ABString)this.getData(aRowNo, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString)).in_read(chn);
                        break;
                    }
                    case -2: 
                    case 30: 
                    case 20001: 
                    case 20002: {
                        chn.in_get((ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer));
                        break;
                    }
                    default: {
                        ex.exception((short)33);
                    }
                }
                cbr.getByte();
                break;
            }
            case 19: {
                ((BitSet)this.getData(aRowNo, class$Altibase$jdbc$driver$BitSet == null ? (class$Altibase$jdbc$driver$BitSet = BindMeta.class$("Altibase.jdbc.driver.BitSet")) : class$Altibase$jdbc$driver$BitSet)).read(chn);
                break;
            }
            case 20: {
                ((BitSet)this.getData(aRowNo, class$Altibase$jdbc$driver$BitSet == null ? (class$Altibase$jdbc$driver$BitSet = BindMeta.class$("Altibase.jdbc.driver.BitSet")) : class$Altibase$jdbc$driver$BitSet)).in_read(chn);
                cbr.getByte();
                break;
            }
            case 21: {
                cbr.intValue();
                chn.get((ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer));
                break;
            }
            case 22: {
                cbr.intValue();
                chn.in_get((ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer));
                cbr.getByte();
                break;
            }
            case 23: {
                switch (this.mDataType) {
                    case 31: {
                        ((Blob)this.getData(aRowNo, class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob)).init(cbr.longValue(), chn);
                        cbr.intValue();
                        break;
                    }
                    case 41: {
                        long sLocator = cbr.longValue();
                        ((Clob)this.getData(aRowNo, class$Altibase$jdbc$driver$Clob == null ? (class$Altibase$jdbc$driver$Clob = BindMeta.class$("Altibase.jdbc.driver.Clob")) : class$Altibase$jdbc$driver$Clob)).setLocator(sLocator, chn);
                        cbr.intValue();
                    }
                }
                break;
            }
            default: {
                ex.exception((short)33);
            }
        }
    }

    final Object reAlloc() {
        ArrayList old = this.mColumnData;
        this.mColumnData = new ArrayList();
        return old;
    }

    final Object replaceData(ArrayList aObj) {
        ArrayList old = this.mColumnData;
        this.mColumnData = aObj;
        return old;
    }

    final void set(int row, ABString v) throws SQLException {
        this.setData(row, v);
    }

    final void set(int row, BigDecimal v) throws SQLException {
        mtdNumeric numericValue = new mtdNumeric(this.mPrecision);
        numericValue.set(v);
        this.setData(row, numericValue);
    }

    final void set(int row, Blob v) throws SQLException {
        this.setData(row, v);
    }

    final void set(int row, Clob v) throws SQLException {
        this.setData(row, v);
    }

    final void set(int row, boolean v) {
        if (v) {
            this.setData(row, new Byte(1));
        } else {
            this.setData(row, new Byte(0));
        }
    }

    final void set(int row, byte v) {
        this.setData(row, new Byte(v));
    }

    final void set(int row, ByteBuffer v) {
        this.setData(row, v);
    }

    final void set(int row, double v) {
        this.setData(row, new Double(v));
    }

    final void set(int row, float v) {
        this.setData(row, new Float(v));
    }

    final void set(int row, int v) {
        this.setData(row, new Integer(v));
    }

    final void set(int row, Date v) throws SQLException {
        mtdDate d = new mtdDate();
        d.setDate(v);
        this.setData(row, d);
    }

    final void set(int row, Time v) throws SQLException {
        mtdDate d = new mtdDate();
        d.setTime(v);
        this.setData(row, d);
    }

    final void set(int row, Timestamp v) throws SQLException {
        mtdDate d = new mtdDate();
        d.setTimestamp(v);
        this.setData(row, d);
    }

    final void set(int row, long v) {
        this.setData(row, new Long(v));
    }

    final void set(int row, short v) {
        this.setData(row, new Short(v));
    }

    final void set(int row, String v) throws SQLException {
        ABString str = new ABString(this.mEncoder, this.mPrecision);
        str.set(v);
        this.setData(row, str);
    }

    final void set(int row, java.util.BitSet v, int scale) throws SQLException {
        BitSet bs = new BitSet(this.mPrecision);
        bs.set(v, scale);
        this.setData(row, bs);
    }

    final void setBitSet(int row, byte[] v) throws SQLException {
        BitSet bs = new BitSet(this.mPrecision);
        bs.set(v);
        this.setData(row, bs);
    }

    final void setBitSet(int row, String v) throws SQLException {
        BitSet bs = new BitSet(this.mPrecision);
        bs.set(v);
        this.setData(row, bs);
    }

    final void setArguments(byte arguments) {
        this.mArguments = arguments;
    }

    void setColumnName(String name) {
        this.mColumnName = name.trim();
    }

    private boolean isLobLocatorType(int aType) {
        return aType == 31 || aType == 41;
    }

    final boolean setDataType(int aDataType, int aPrecision, int aDataPrecision) throws SQLException {
        if (this.mDataType != aDataType || this.mPrecision != aPrecision) {
            this.mArguments = 0;
            this.mPrecision = aPrecision;
            this.mDataPrecision = aDataPrecision;
            this.mScale = 0;
            if (this.isLobLocatorType(this.mDataType) && !this.isLobLocatorType(aDataType) || !this.isLobLocatorType(this.mDataType) && this.isLobLocatorType(aDataType)) {
                this.mInOutType = 0;
            }
            switch (aDataType) {
                case -2: 
                case 1: 
                case 12: 
                case 30: 
                case 40: 
                case 20001: 
                case 20002: {
                    this.mArguments = 1;
                    break;
                }
                case 6: {
                    this.mPrecision = 38;
                    this.mArguments = 1;
                    break;
                }
                case 2: 
                case 10002: {
                    this.mPrecision = 38;
                    this.mScale = 20;
                    this.mArguments = (byte)2;
                    break;
                }
                case -8: 
                case -7: {
                    this.mArguments = 1;
                }
            }
            this.mIsBindInfoParam = true;
            this.mDataType = aDataType;
        }
        return this.mIsBindInfoParam;
    }

    final boolean setInOutType(byte inOutType) {
        if (this.mInOutType != inOutType) {
            this.mInOutType = inOutType;
            this.mIsBindInfoParam = true;
        }
        return this.mIsBindInfoParam;
    }

    final boolean setLanguage(int language) {
        if (this.mLanguage != language) {
            this.mLanguage = language;
            this.mIsBindInfoParam = true;
        }
        return this.mIsBindInfoParam;
    }

    final void setEncoder(ABEncoder aEncoder) {
        this.mEncoder = aEncoder;
    }

    final void setNull(int aRowNo) throws SQLException {
        switch (this.mDataType) {
            case 16: {
                this.setData(aRowNo, new Byte(-128));
                break;
            }
            case 5: {
                this.setData(aRowNo, new Short(Short.MIN_VALUE));
                break;
            }
            case 4: {
                this.setData(aRowNo, new Integer(Integer.MIN_VALUE));
                break;
            }
            case -5: {
                this.setData(aRowNo, new Long(Long.MIN_VALUE));
                break;
            }
            case 7: {
                this.setData(aRowNo, new Float(Float.NaN));
                break;
            }
            case 8: {
                this.setData(aRowNo, new Double(Double.NaN));
                break;
            }
            case 1: 
            case 12: 
            case 30: 
            case 40: {
                ABString s = new ABString(this.mEncoder, this.mDataPrecision);
                s.setNull();
                this.setData(aRowNo, s);
                break;
            }
            case -2: 
            case 20001: 
            case 20002: {
                ByteBuffer bb = ByteBuffer.allocate(0);
                this.setData(aRowNo, bb);
                break;
            }
            case 31: {
                Blob blob = (Blob)this.getData(aRowNo, class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob);
                blob.setNull();
                break;
            }
            case 41: {
                Clob clob = (Clob)this.getData(aRowNo, class$Altibase$jdbc$driver$Clob == null ? (class$Altibase$jdbc$driver$Clob = BindMeta.class$("Altibase.jdbc.driver.Clob")) : class$Altibase$jdbc$driver$Clob);
                clob.setNull();
                break;
            }
            case 10: {
                mtdInterval interval = new mtdInterval();
                interval.setNull();
                break;
            }
            case 9: {
                mtdDate date = new mtdDate();
                date.setNull();
                this.setData(aRowNo, date);
                break;
            }
            case 2: 
            case 6: 
            case 10002: {
                mtdNumeric numeric = new mtdNumeric(this.mPrecision);
                numeric.setNull();
                this.setData(aRowNo, numeric);
                break;
            }
            case -8: 
            case -7: {
                BitSet bs = new BitSet(this.mPrecision);
                bs.setNull();
                this.setData(aRowNo, bs);
            }
        }
    }

    final void setNullableFlag(byte nullableFlag) {
        this.mNullableFlag = nullableFlag;
    }

    final boolean setScale(int scale) {
        if (this.mScale != scale) {
            this.mScale = scale;
            this.mIsBindInfoParam = true;
        }
        return this.mIsBindInfoParam;
    }

    final int getMTType(int aDataType) throws SQLException {
        int sDataType = 0;
        switch (aDataType) {
            case -5: {
                sDataType = -5;
                break;
            }
            case -4: 
            case -3: {
                sDataType = 30;
                break;
            }
            case 2004: {
                sDataType = 31;
                break;
            }
            case 2005: {
                sDataType = 41;
                break;
            }
            case 16: {
                sDataType = 16;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                sDataType = 1;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                sDataType = 9;
                break;
            }
            case 8: {
                sDataType = 8;
                break;
            }
            case 2: 
            case 3: {
                sDataType = 2;
                break;
            }
            case 6: {
                sDataType = 6;
                break;
            }
            case 7: {
                sDataType = 7;
                break;
            }
            case -6: 
            case 5: {
                sDataType = 5;
                break;
            }
            case -7: {
                sDataType = -8;
                break;
            }
            case 4: {
                sDataType = 4;
                break;
            }
            case -2: {
                sDataType = -2;
                break;
            }
            case 20001: {
                sDataType = 20001;
                break;
            }
            case 20002: {
                sDataType = 20002;
                break;
            }
            case 0: {
                sDataType = 0;
                break;
            }
            default: {
                ex.exception((short)103, SQLStates.mFixmsg[30]);
            }
        }
        return sDataType;
    }

    final boolean setSQLType(int aType) throws SQLException {
        boolean ret = false;
        switch (aType) {
            case -5: {
                ret = this.setDataType(-5, 19, 19);
                break;
            }
            case -3: {
                ret = this.setDataType(30, 32000, 32000);
                break;
            }
            case 2004: {
                ret = this.setDataType(31, 19, 19);
                break;
            }
            case 2005: {
                ret = this.setDataType(41, 19, 19);
                break;
            }
            case 16: {
                ret = this.setDataType(16, 1, 1);
                break;
            }
            case 1: 
            case 12: {
                ret = this.setDataType(1, 32000, 32000);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                ret = this.setDataType(9, 30, 30);
                break;
            }
            case 8: {
                ret = this.setDataType(8, 15, 15);
                break;
            }
            case 2: 
            case 3: {
                ret = this.setDataType(2, 38, 38);
                break;
            }
            case 1111: {
                ret = this.setDataType(10003, 32000, 32000);
                break;
            }
            case -2: {
                ret = this.setDataType(-2, 32000, 32000);
                break;
            }
            case 4: {
                ret = this.setDataType(4, 10, 10);
                break;
            }
            case 0: {
                ret = this.setDataType(0, 4, 4);
                break;
            }
            case 6: {
                ret = this.setDataType(6, 38, 38);
                break;
            }
            case 7: {
                ret = this.setDataType(7, 7, 7);
                break;
            }
            case 5: {
                ret = this.setDataType(5, 5, 5);
                break;
            }
            case -7: {
                ret = this.setDataType(-8, 65536, 65536);
                break;
            }
            default: {
                ex.exception((short)103, SQLStates.mFixmsg[30]);
            }
        }
        return ret;
    }

    public String toString() {
        return this.mColumnName + " [" + "  col:" + this.mColumnNo + ", arg:" + this.mArguments + ", typ:" + this.mDataType + ", ino:" + this.mInOutType + ", lan:" + this.mLanguage + ", nul:" + this.mNullableFlag + ", prc:" + this.mPrecision + ", scl:" + this.mScale + "]\n";
    }

    final void writeOutParamData(cmp chn, int aStmtId, short aRowNo) throws SQLException {
        if (this.mInOutType != 4) {
            cmb cbw = chn.next((byte)27);
            cbw.putInt(aStmtId);
            cbw.putShort(this.mColumnNo);
            switch (this.mDataType) {
                case 16: {
                    cbw.putByte((byte)3);
                    cbw.putByte((Byte)this.getData(aRowNo, class$java$lang$Byte == null ? (class$java$lang$Byte = BindMeta.class$("java.lang.Byte")) : class$java$lang$Byte));
                    break;
                }
                case 5: {
                    cbw.putByte((byte)4);
                    cbw.putShort((Short)this.getData(aRowNo, class$java$lang$Short == null ? (class$java$lang$Short = BindMeta.class$("java.lang.Short")) : class$java$lang$Short));
                    break;
                }
                case 4: {
                    cbw.putByte((byte)6);
                    cbw.putInt((Integer)this.getData(aRowNo, class$java$lang$Integer == null ? (class$java$lang$Integer = BindMeta.class$("java.lang.Integer")) : class$java$lang$Integer));
                    break;
                }
                case -5: {
                    cbw.putByte((byte)8);
                    cbw.putLong((Long)this.getData(aRowNo, class$java$lang$Long == null ? (class$java$lang$Long = BindMeta.class$("java.lang.Long")) : class$java$lang$Long));
                    break;
                }
                case 41: {
                    cbw.putByte((byte)9);
                    cbw.putLong(((Clob)this.getData(aRowNo, class$Altibase$jdbc$driver$Clob == null ? (class$Altibase$jdbc$driver$Clob = BindMeta.class$("Altibase.jdbc.driver.Clob")) : class$Altibase$jdbc$driver$Clob)).locator());
                    break;
                }
                case 31: {
                    cbw.putByte((byte)9);
                    cbw.putLong(((Blob)this.getData(aRowNo, class$Altibase$jdbc$driver$Blob == null ? (class$Altibase$jdbc$driver$Blob = BindMeta.class$("Altibase.jdbc.driver.Blob")) : class$Altibase$jdbc$driver$Blob)).locator());
                    break;
                }
                case 7: {
                    cbw.putByte((byte)10);
                    cbw.putFloat(((Float)this.getData(aRowNo, class$java$lang$Float == null ? (class$java$lang$Float = BindMeta.class$("java.lang.Float")) : class$java$lang$Float)).floatValue());
                    break;
                }
                case 8: {
                    cbw.putByte((byte)11);
                    cbw.putDouble((Double)this.getData(aRowNo, class$java$lang$Double == null ? (class$java$lang$Double = BindMeta.class$("java.lang.Double")) : class$java$lang$Double));
                    break;
                }
                case 1: 
                case 12: 
                case 40: {
                    ABString str = (ABString)this.getData(aRowNo, class$Altibase$jdbc$driver$ABString == null ? (class$Altibase$jdbc$driver$ABString = BindMeta.class$("Altibase.jdbc.driver.ABString")) : class$Altibase$jdbc$driver$ABString);
                    if (str.isNull()) {
                        cbw.putByte((byte)1);
                        break;
                    }
                    cbw = chn.setAny((byte)15);
                    str.write(chn);
                    break;
                }
                case 20002: {
                    ByteBuffer bb = (ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
                    if (this.isnull(bb)) {
                        cbw.putByte((byte)1);
                        break;
                    }
                    cbw = chn.setAny((byte)21);
                    cbw.putInt(bb.limit() * 2);
                    chn.putBuffer(bb);
                    break;
                }
                case -2: 
                case 30: 
                case 20001: {
                    ByteBuffer bb = (ByteBuffer)this.getData(aRowNo, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = BindMeta.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
                    if (this.isnull(bb)) {
                        cbw.putByte((byte)1);
                        break;
                    }
                    cbw = chn.setAny((byte)17);
                    chn.putBuffer(bb);
                    break;
                }
                case 9: {
                    ((mtdDate)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdDate == null ? (class$Altibase$jdbc$driver$mtdDate = BindMeta.class$("Altibase.jdbc.driver.mtdDate")) : class$Altibase$jdbc$driver$mtdDate)).write(chn);
                    break;
                }
                case 10: {
                    ((mtdInterval)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdInterval == null ? (class$Altibase$jdbc$driver$mtdInterval = BindMeta.class$("Altibase.jdbc.driver.mtdInterval")) : class$Altibase$jdbc$driver$mtdInterval)).write(chn);
                    break;
                }
                case 2: 
                case 6: 
                case 10002: {
                    ((mtdNumeric)this.getData(aRowNo, class$Altibase$jdbc$driver$mtdNumeric == null ? (class$Altibase$jdbc$driver$mtdNumeric = BindMeta.class$("Altibase.jdbc.driver.mtdNumeric")) : class$Altibase$jdbc$driver$mtdNumeric)).write(chn);
                    break;
                }
                case -8: 
                case -7: {
                    ((BitSet)this.getData(aRowNo, class$Altibase$jdbc$driver$BitSet == null ? (class$Altibase$jdbc$driver$BitSet = BindMeta.class$("Altibase.jdbc.driver.BitSet")) : class$Altibase$jdbc$driver$BitSet)).write(chn);
                    break;
                }
                default: {
                    cbw.putByte((byte)1);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

