/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.aTokenizer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DataSource
implements Referenceable,
Serializable,
javax.sql.DataSource {
    static final long serialVersionUID = 1L;
    protected String dataSourceName = null;
    protected transient PrintWriter logger;
    protected Properties prop = new Properties();
    protected String user = new String();
    protected String password = new String();

    public void close() {
    }

    public Connection getConnection() throws SQLException {
        return new ABConnection(this.prop);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Properties pnew = (Properties)this.prop.clone();
        pnew.setProperty("user", user);
        pnew.setProperty("password", password);
        try {
            ABConnection con = new ABConnection(pnew);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + user + " at " + this.getUrl());
            }
            return con;
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.println(SQLStates.mFixmsg[38] + user + " at " + this.getUrl() + ": " + e);
            }
            throw e;
        }
    }

    public String getDatabaseName() {
        return this.prop.getProperty("databaseName", "MYDB");
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.prop.getProperty("description", "Simple Altibase DataSource");
    }

    public String getEncoding() {
        return this.prop.getProperty("encoding");
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPortNumber() {
        return Integer.parseInt(this.prop.getProperty("portNumber", "20300"));
    }

    String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "Altibase.jdbc.driver.DataSourceObjectFactory", null);
        ref.add(new StringRefAddr("dataSourceName", this.prop.getProperty("dataSourceName", this.dataSourceName)));
        ref.add(new StringRefAddr("serverName", this.prop.getProperty("serverName", "localhost")));
        ref.add(new StringRefAddr("portNumber", this.prop.getProperty("portNumber", "20300")));
        ref.add(new StringRefAddr("databaseName", this.prop.getProperty("databaseName", "MYDB")));
        ref.add(new StringRefAddr("user", this.prop.getProperty("user", "")));
        ref.add(new StringRefAddr("password", this.prop.getProperty("password", "")));
        ref.add(new StringRefAddr("description", this.prop.getProperty("description", "Simple Altibase DataSource")));
        if (this.prop.containsKey("encoding")) {
            ref.add(new StringRefAddr("encoding", this.prop.getProperty("encoding")));
        }
        return ref;
    }

    public String getServerName() {
        return this.prop.getProperty("serverName");
    }

    public String getUrl() {
        return aTokenizer.getUrl(this.prop);
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabaseName(String databaseName) {
        this.prop.setProperty("databaseName", databaseName);
    }

    public void setDataSourceName(String dsn) {
        this.dataSourceName = dsn;
        this.prop.setProperty("dataSourceName", this.dataSourceName);
    }

    public void setDescription(String ds) {
        this.prop.setProperty("description", ds);
    }

    public void setEncoding(String encode) {
        this.prop.setProperty("encoding", encode);
    }

    public void setLoginTimeout(int i) throws SQLException {
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public void setPassword(String password) {
        this.password = password;
        this.prop.setProperty("password", password);
    }

    public void setPortNumber(int portNumber) {
        this.prop.setProperty("portNumber", Integer.toString(portNumber));
    }

    public void setServerName(String serverName) {
        if (serverName == null || serverName.equals("")) {
            this.prop.setProperty("serverName", "localhost");
        } else {
            this.prop.setProperty("serverName", serverName);
        }
    }

    public void setUrl(String url) {
        int i;
        if (url.startsWith("jdbc:Altibase://")) {
            if (url.length() < 16) {
                return;
            }
            url = url.substring(16);
        }
        if ((i = url.indexOf(58)) == -1) {
            this.setPortNumber(20300);
            i = url.indexOf(47);
            if (i == -1 || url.length() < i + 1) {
                return;
            }
            this.setServerName(url.substring(0, i));
        } else {
            this.setServerName(url.substring(0, i));
            if (url.length() < ++i) {
                return;
            }
            if ((i = (url = url.substring(i)).indexOf(47)) == -1 || url.length() < i + 1) {
                return;
            }
            try {
                this.setPortNumber(Integer.parseInt(url.substring(0, i)));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        url = url.substring(++i);
        i = url.indexOf(63);
        if (i == -1) {
            this.setDatabaseName(url.substring(0));
        } else {
            this.setDatabaseName(url.substring(0, i++));
            url = url.substring(i);
            aTokenizer.setProperties(url, this.prop);
        }
    }

    public void setUser(String user) {
        this.user = user;
        this.prop.setProperty("user", user);
    }

    static {
        try {
            Class.forName("Altibase.jdbc.driver.AltibaseDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println(SQLStates.mFixmsg[39]);
        }
    }
}

