/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class TbBlob
extends TbLob
implements Blob {
    private static final TbBlob EMPTY_BLOB = new TbBlob(null, new byte[1]);

    public TbBlob(TbConnection conn, byte[] locator) {
        super(conn, locator);
    }

    private TbBlobAccessor getBlobAccessor() {
        return this.getConnection().getBlobAccessor();
    }

    public long length() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getBlobAccessor().length(this);
    }

    public byte[] getBytes(long pos, int size) throws SQLException {
        this.checkInvalidActionOnEmpty();
        byte[] ret = null;
        if (size < 0 || pos < 1L) {
            throw new TbSQLException(-590713);
        }
        if (size == 0) {
            ret = new byte[]{};
        } else {
            byte[] buf = new byte[size];
            long numRead = this.getBytes(pos, buf);
            if (numRead < (long)size) {
                ret = new byte[(int)numRead];
                System.arraycopy(buf, 0, ret, 0, (int)numRead);
                buf = null;
            } else if (numRead == (long)size) {
                ret = buf;
            }
        }
        return ret;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this);
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw new TbSQLException(-590713);
        }
        return new TbLobOutputStream(this, pos);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw new TbSQLException(-590713);
        }
        return new TbLobOutputStream(this, pos);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (start < 1L) {
            throw new TbSQLException(-590713);
        }
        return this.getBlobAccessor().position(this, pattern, start - 1L);
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (start < 1L) {
            throw new TbSQLException(-590713);
        }
        return this.getBlobAccessor().position(this, (TbBlob)pattern, start - 1L);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (len < 0 || pos < 1L) {
            throw new TbSQLException(-590713);
        }
        if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        if (len <= 0) {
            return 0;
        }
        return (int)this.getBlobAccessor().write(this, pos - 1L, bytes, offset, len);
    }

    public void truncate(long len) throws SQLException {
        this.checkInvalidActionOnEmpty();
        this.getBlobAccessor().truncate(this, len);
    }

    public long getBytes(long offset, byte[] buffer) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getBytes(offset, buffer, buffer.length);
    }

    public long getBytes(long offset, byte[] buffer, long numBytes) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return this.getBytes(offset, buffer, 0L, buffer.length);
    }

    public long getBytes(long offset, byte[] buffer, long bufOffset, long numBytes) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (numBytes < 0L || offset < 1L) {
            throw new TbSQLException(-590713);
        }
        if (numBytes > (long)buffer.length) {
            numBytes = buffer.length;
        }
        if (numBytes == 0L) {
            return 0L;
        }
        return this.getBlobAccessor().read(this, offset - 1L, buffer, bufOffset, numBytes);
    }

    public static TbBlob createTemporary(Connection conn) throws SQLException {
        if (conn == null) {
            throw new TbSQLException(-590713);
        }
        byte[] locator = ((TbConnection)conn).getBlobAccessor().createTemporaryBlob();
        return new TbBlob((TbConnection)conn, locator);
    }

    public static void freeTemporary(TbBlob blob) throws SQLException {
        if (blob == null) {
            throw new TbSQLException(-590713);
        }
        blob.freeTemporary();
    }

    public void freeTemporary() throws SQLException {
        this.getBlobAccessor().freeTemporaryBlob(this);
    }

    public void open(int mode) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (mode != 0 && mode != 1) {
            throw new TbSQLException(-590713);
        }
        this.getBlobAccessor().open(this, mode);
    }

    public void close() throws SQLException {
        this.checkInvalidActionOnEmpty();
        this.getBlobAccessor().close(this);
    }

    public static TbBlob createEmptyBlob() {
        return EMPTY_BLOB;
    }
}

