/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class TbClobReader
extends Reader {
    private TbClob clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private char[] buf = null;
    private boolean opened = false;

    public TbClobReader(TbClob clob) throws SQLException {
        if (clob == null) {
            throw new TbSQLException(-590713);
        }
        this.clob = clob;
        this.bufOffset = 0;
        this.lobOffset = 0L;
        this.fetchedSize = 0;
        this.buf = new char[TbLob.MAX_CHUNK_SIZE];
        this.opened = true;
        this.readNextBuffer();
    }

    private void assertOpen() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    private int getRemainedInBuffer() {
        return this.fetchedSize - this.bufOffset;
    }

    private void readNextBuffer() throws SQLException {
        long readCnt = 0L;
        readCnt = this.clob.getChars(this.lobOffset + 1L, this.buf);
        this.fetchedSize = (int)readCnt;
        this.lobOffset += readCnt;
        this.bufOffset = 0;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.assertOpen();
        if (this.getRemainedInBuffer() == 0) {
            if (this.clob.isEndOfStream()) {
                return -1;
            }
            try {
                this.readNextBuffer();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.getRemainedInBuffer() >= len) {
            System.arraycopy(this.buf, this.bufOffset, cbuf, off, len);
            this.bufOffset += len;
            return len;
        }
        int readLen = 0;
        while (len > readLen) {
            int splitLen = this.getRemainedInBuffer();
            if (splitLen > len - readLen) {
                splitLen = len - readLen;
            }
            System.arraycopy(this.buf, this.bufOffset, cbuf, off + readLen, splitLen);
            readLen += splitLen;
            this.bufOffset += splitLen;
            if (this.getRemainedInBuffer() != 0) continue;
            if (!this.clob.isEndOfStream()) {
                try {
                    this.readNextBuffer();
                    continue;
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return readLen;
        }
        return readLen;
    }

    public void close() throws IOException {
        this.opened = false;
        this.clob = null;
        this.buf = null;
    }
}

