/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class TbDriver
implements Driver {
    public Connection connect(String url, Properties infos) throws SQLException {
        ConnectionInfo info = TbUrlParser.parseUrl(url, infos);
        return this._getConnection(info);
    }

    public Connection connect(ConnectionInfo info) throws SQLException {
        return this._getConnection(info);
    }

    private synchronized Connection _getConnection(ConnectionInfo info) throws SQLException {
        if (info == null) {
            return null;
        }
        try {
            TbConnection connection = new TbConnection();
            connection.openConnection(info);
            return connection;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            if (TbUrlParser.parseUrl(url, null) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        try {
            return Integer.parseInt("3");
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return Integer.parseInt("0");
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getRevision() {
        try {
            return Integer.parseInt("29568");
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static String GetBuildString() {
        return "3-0-980 (Rev: 29568)";
    }

    static {
        try {
            DriverManager.registerDriver(new TbDriver());
        }
        catch (SQLException sqe) {
            throw new RuntimeException("Failed to register TiberoDriver:" + sqe.getMessage());
        }
    }
}

