/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

public class TbIntervalDts {
    private final int MID_INT = 0x40000000;
    byte[] bytes;

    public TbIntervalDts(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        int fprec = 0;
        int mult = 1;
        int day = this.getIntFromBigEndianBytes(this.bytes, 0);
        int ts_per_day = this.getIntFromBigEndianBytes(this.bytes, 4);
        int fsec = this.getIntFromBigEndianBytes(this.bytes, 8);
        ts_per_day = Math.abs(ts_per_day);
        int hour = ts_per_day / 3600;
        int min = (ts_per_day -= hour * 3600) / 60;
        int sec = ts_per_day -= min * 60;
        fsec = Math.abs(fsec);
        for (int i = 0; i < 9 - fprec; ++i) {
            mult *= 10;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(day + " " + hour + ":" + min + ":" + sec + "." + (fsec /= mult));
        return sb.toString();
    }

    private int getIntFromBigEndianBytes(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (0xFF & bytes[offset + i]) << 8 * (3 - i);
        }
        return value -= 0x40000000;
    }
}

