/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.util.TbCalendar;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Date;

public class TbPivotValReader {
    Blob blobData;
    byte[] byteData;
    int itemCnt;
    int[] nameIdx;
    int[] offset;
    InputStream in;
    int byteArrPos;

    private int getNextIntForHdr() throws Exception {
        int retval = 0;
        int shift = 24;
        for (int i = 0; i < 4; ++i) {
            int readByte = this.in.read();
            retval += readByte << shift;
            shift -= 8;
        }
        return retval;
    }

    private int getNextIntFrom4ByteArr() {
        int retval = 0;
        int i = 0;
        int shift = 24;
        while (i < 4) {
            int b = 0xFF & this.byteData[this.byteArrPos + i];
            retval += b << shift;
            ++i;
            shift -= 8;
        }
        this.byteArrPos += 4;
        return retval;
    }

    private int getNextIntFrom2ByteArr() {
        int retval = ((0xFF & this.byteData[this.byteArrPos]) << 8) + (0xFF & this.byteData[this.byteArrPos + 1]);
        this.byteArrPos += 2;
        return retval;
    }

    private byte getNextByteFromByteArr() {
        ++this.byteArrPos;
        return this.byteData[this.byteArrPos - 1];
    }

    private int getNextByte() throws Exception {
        if (this.byteData == null) {
            return this.in.read();
        }
        return 0xFF & this.getNextByteFromByteArr();
    }

    public TbPivotValReader(Blob data) throws Exception {
        this.blobData = data;
        this.byteArrPos = 0;
        this.byteData = null;
        this.byteData = ((TbBlob)data).getLobData();
        if (this.byteData == null) {
            this.in = data.getBinaryStream();
            this.itemCnt = this.getNextIntForHdr();
            this.nameIdx = new int[this.itemCnt];
            this.offset = new int[this.itemCnt];
            for (int i = 0; i < this.itemCnt; ++i) {
                this.nameIdx[i] = this.getNextIntForHdr();
                this.offset[i] = this.getNextIntForHdr();
            }
        } else {
            this.itemCnt = this.getNextIntFrom4ByteArr();
            this.nameIdx = new int[this.itemCnt];
            this.offset = new int[this.itemCnt];
            for (int i = 0; i < this.itemCnt; ++i) {
                this.nameIdx[i] = this.getNextIntFrom4ByteArr();
                this.offset[i] = this.getNextIntFrom2ByteArr();
            }
        }
    }

    public int getColNameIdx(int i) throws Exception {
        return this.nameIdx[i];
    }

    public int getCnt() {
        return this.itemCnt;
    }

    public Long getNextLong() throws Exception {
        Long retval;
        if (this.byteData == null) {
            int colLen = this.in.read();
            if (colLen == 0) {
                return null;
            }
            if (colLen == -1) {
                throw new Exception("invalid length read");
            }
            if (colLen > 250) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            int readCnt = this.in.read(data, 1, colLen);
            if (readCnt != colLen) {
                throw new Exception("data corruption");
            }
            retval = new Long(TbNumber.getLongFromRawBytes(data, 0, colLen + 1));
        } else {
            int colLen = this.getNextByteFromByteArr();
            if (colLen == 0) {
                return null;
            }
            if (colLen > 250 || colLen < 1) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            for (int i = 0; i < colLen; ++i) {
                data[i + 1] = this.getNextByteFromByteArr();
            }
            retval = new Long(TbNumber.getLongFromRawBytes(data, 0, colLen + 1));
        }
        return retval;
    }

    public Integer getNextInt() throws Exception {
        Integer retval;
        if (this.byteData == null) {
            int colLen = this.in.read();
            if (colLen == 0) {
                return null;
            }
            if (colLen == -1) {
                throw new Exception("invalid length read");
            }
            if (colLen > 250) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            int readCnt = this.in.read(data, 1, colLen);
            if (readCnt != colLen) {
                throw new Exception("data corruption");
            }
            retval = new Integer(TbNumber.getIntFromRawBytes(data, 0, colLen + 1));
        } else {
            int colLen = this.getNextByteFromByteArr();
            if (colLen == 0) {
                return null;
            }
            if (colLen > 250 || colLen < 1) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            for (int i = 0; i < colLen; ++i) {
                data[i + 1] = this.getNextByteFromByteArr();
            }
            retval = new Integer(TbNumber.getIntFromRawBytes(data, 0, colLen + 1));
        }
        return retval;
    }

    public Double getNextDouble() throws Exception {
        Double retval;
        if (this.byteData == null) {
            int colLen = this.in.read();
            if (colLen == 0) {
                return null;
            }
            if (colLen == -1) {
                throw new Exception("invalid length read");
            }
            if (colLen > 250) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            int readCnt = this.in.read(data, 1, colLen);
            if (readCnt != colLen) {
                throw new Exception("data corruption");
            }
            retval = new Double(TbNumber.getDoubleFromRawBytes(data, 0, colLen + 1));
        } else {
            int colLen = this.getNextByteFromByteArr();
            if (colLen == 0) {
                return null;
            }
            if (colLen > 250 || colLen < 1) {
                throw new Exception("rpcol length field curruption");
            }
            byte[] data = new byte[colLen + 1];
            data[0] = (byte)colLen;
            for (int i = 0; i < colLen; ++i) {
                data[i + 1] = this.getNextByteFromByteArr();
            }
            retval = new Double(TbNumber.getDoubleFromRawBytes(data, 0, colLen + 1));
        }
        return retval;
    }

    public String getNextString() throws Exception {
        int colLen = -1;
        int firstLenByte = this.getNextByte();
        if (firstLenByte == -1) {
            throw new Exception("invalid length read");
        }
        if (firstLenByte <= 250) {
            colLen = firstLenByte;
        } else if (firstLenByte == 254) {
            int secondLenByte = this.getNextByte();
            int thirdLenByte = this.getNextByte();
            colLen = 0xFF & secondLenByte << 8;
            colLen &= 0xFF & thirdLenByte;
        } else {
            throw new Exception("rpcol length field curruption");
        }
        byte[] strData = new byte[colLen];
        if (this.byteData == null) {
            int readCnt = this.in.read(strData, 0, colLen);
            if (readCnt != colLen) {
                throw new Exception("data corruption");
            }
        } else {
            for (int i = 0; i < colLen; ++i) {
                strData[i] = this.getNextByteFromByteArr();
            }
        }
        return new String(strData);
    }

    public Date getNextDate() throws Exception {
        int colLen = this.getNextByte();
        if (colLen == 0) {
            return null;
        }
        if (colLen != 8) {
            throw new Exception("rpcol length field curruption, colLen: " + colLen);
        }
        byte[] data = new byte[colLen];
        if (this.byteData == null) {
            int readCnt = this.in.read(data, 0, colLen);
            if (readCnt != colLen) {
                throw new Exception("data corruption");
            }
        } else {
            for (int i = 0; i < colLen; ++i) {
                data[i] = this.getNextByteFromByteArr();
            }
        }
        int db_century = 0xFF & data[0];
        int db_year = 0xFF & data[1];
        int db_month = 0xFF & data[2];
        int day = 0xFF & data[3];
        int hour = 0xFF & data[4];
        int minute = 0xFF & data[5];
        int second = 0xFF & data[6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(year, month, day, hour, minute, second);
        return new Date(calendar.getTimeInMillis());
    }
}

