/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.Row;
import java.sql.SQLException;

public class TbRSFwOnlyCsr
extends TbResultSetBase {
    protected Row[] rows;
    protected int curRowCnt;
    protected int lastFetchedCnt;
    private boolean isResetRows;

    protected TbRSFwOnlyCsr(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt);
        this.rows = new Row[this.fetchSize];
        this.curRowCnt = 0;
        this.lastFetchedCnt = 0;
        this.isResetRows = true;
        this.currentRowIndex = -1;
        this.lastFetchedCnt = 0;
        this.makeRowDataArray();
    }

    public int addRows(Row[] rows) throws SQLException {
        this.lastFetchedCnt = this.rowsFetchedCnt;
        this.rowsFetchedCnt += this.curRowCnt;
        return this.curRowCnt;
    }

    private void checkRowIndex(int rowIndex) throws SQLException {
        if (rowIndex < 0) {
            throw new TbSQLException(-90635);
        }
        if (rowIndex >= this.rowsFetchedCnt && this.fetchComplete) {
            throw new TbSQLException(-90624);
        }
        if (rowIndex < this.lastFetchedCnt || rowIndex >= this.rowsFetchedCnt) {
            throw new TbSQLException(-90624);
        }
    }

    protected Row getCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        return this.rows[this.currentRowIndex - this.lastFetchedCnt];
    }

    protected Row getRowAt(int rowIndex) throws SQLException {
        this.checkRowIndex(rowIndex);
        return this.rows[rowIndex - this.lastFetchedCnt];
    }

    public Row[] getRows(int rowCnt) throws SQLException {
        this.curRowCnt = rowCnt;
        if (rowCnt > this.rows.length) {
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = null;
            }
            this.rows = new Row[rowCnt];
            this.makeRowDataArray();
        }
        return this.rows;
    }

    private void makeRowDataArray() {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(this.colCnt);
        }
    }

    public synchronized boolean next() throws SQLException {
        if (!super.next()) {
            this.closeCursor();
            return false;
        }
        return true;
    }

    protected void removeCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        Row row = this.getCurrentRow();
        row.setDeleted(true);
    }

    protected void reset() {
        super.reset();
        if (this.rows != null) {
            this.rowsClear();
            this.rows = null;
        }
    }

    private void rowsClear() {
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.isResetRows) {
                this.rows[i].reset();
            }
            this.rows[i] = null;
        }
    }

    public void setResetRows(boolean isResetRows) {
        this.isResetRows = isResetRows;
    }

    protected void setRowAt(int rowIndex, Row row) throws SQLException {
        this.checkRowIndex(rowIndex);
        this.rows[rowIndex - this.lastFetchedCnt] = null;
        this.rows[rowIndex - this.lastFetchedCnt] = row;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(" lastFetchedCnt[").append(this.lastFetchedCnt).append("]");
        buf.append(super.ToString());
        return buf.toString();
    }
}

