/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.ext.TbXAException;
import com.tmax.tibero.jdbc.ext.TbXid;
import com.tmax.tibero.jdbc.msg.TbMsgXa;
import com.tmax.tibero.jdbc.msg.TbMsgXaOpen;
import com.tmax.tibero.jdbc.msg.TbMsgXaRecover;
import com.tmax.tibero.jdbc.msg.TbMsgXaRecoverReply;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class TbXACommType4
extends TbCommType4
implements TbXAComm {
    public TbXACommType4(TbConnection tbConnection) {
        super(tbConnection);
    }

    private void deserializeXid(byte[] xidBytes, TbXid[] xids) throws TbXAException {
        int offset = 0;
        int formatId = 0;
        int gtLen = 0;
        int bqLen = 0;
        byte[] gtrid = null;
        byte[] bqual = null;
        int xidCount = xids.length;
        for (int i = 0; i < xidCount; ++i) {
            formatId = TbCommon.byte2int(xidBytes, offset, 8);
            gtLen = TbCommon.byte2int(xidBytes, offset += 8, 8);
            gtrid = new byte[gtLen];
            bqLen = TbCommon.byte2int(xidBytes, offset += 8, 8);
            bqual = new byte[bqLen];
            System.arraycopy(xidBytes, offset += 8, gtrid, 0, gtLen);
            System.arraycopy(xidBytes, offset += gtLen, bqual, 0, bqLen);
            offset += bqLen;
            offset += TbXid.SERIALIZED_SIZE - 24 - gtLen - bqLen;
            xids[i] = new TbXid(formatId, gtrid, bqual);
        }
    }

    private void doXAErrorReply(int errorCode, TbMsg msg) throws TbXAException, SQLException {
        TbSQLException ex = this.getErrorMessage(errorCode, msg);
        throw new TbXAException(this.mappingXAErrorCode(ex.getErrorCode()));
    }

    private int doXAForgetErrorReply(TbMsg msg) throws TbXAException {
        try {
            TbSQLException ex = this.getErrorMessage(-90542, msg);
            if (this.mappingXAErrorCode(ex.getErrorCode()) == 3) {
                return 3;
            }
            if (this.mappingXAErrorCode(ex.getErrorCode()) == -4) {
                return -4;
            }
            TbXAException xae = new TbXAException(this.mappingXAErrorCode(ex.getErrorCode()));
            throw xae;
        }
        catch (SQLException sQLException) {
            return -6;
        }
    }

    private int doXAPrepareErrorReply(TbMsg msg) throws TbXAException {
        try {
            TbSQLException ex = this.getErrorMessage(-90529, msg);
            if (this.mappingXAErrorCode(ex.getErrorCode()) == 3) {
                return 3;
            }
            if (this.mappingXAErrorCode(ex.getErrorCode()) == -4) {
                return -4;
            }
            TbXAException xae = new TbXAException(this.mappingXAErrorCode(ex.getErrorCode()));
            throw xae;
        }
        catch (SQLException sQLException) {
            return -6;
        }
    }

    private Xid[] doXARecoverOK(TbMsgXaRecoverReply replyMsg) throws TbXAException {
        try {
            int xidCount = replyMsg.xidCount;
            Xid[] xids = new TbXid[xidCount];
            byte[] xidBytes = replyMsg.xids;
            int len = xidBytes.length;
            if (len != xidCount * TbXid.SERIALIZED_SIZE) {
                throw new TbSQLException(-90405, "stream buffer reading error");
            }
            if (xidCount > 0) {
                this.deserializeXid(xidBytes, (TbXid[])xids);
            }
            Xid[] xidArray = xids;
            return xidArray;
        }
        catch (SQLException e) {
            throw new TbXAException(-6);
        }
        finally {
            if (this.stream != null) {
                this.stream.skipUnreadPacketData();
            }
        }
    }

    private int mappingXAErrorCode(int code) {
        switch (code) {
            case -25001: {
                return -6;
            }
            case -25005: {
                return -5;
            }
            case -25002: {
                return -4;
            }
            case -25007: {
                return 3;
            }
            case -25008: {
                return -8;
            }
            case -25010: {
                return 7;
            }
            case -25011: {
                return 6;
            }
            case -25012: {
                return 5;
            }
            case -25009: {
                return -3;
            }
            case -25003: {
                return -9;
            }
            case -25004: {
                return -2;
            }
            case -25006: {
                return 100;
            }
            case -25013: {
                return 4;
            }
        }
        return -6;
    }

    private void serializeXid(Xid xid, byte[] xidInternal) {
        int offset = 0;
        int formatId = xid.getFormatId();
        byte[] gt = xid.getGlobalTransactionId();
        byte[] bq = xid.getBranchQualifier();
        int realDataSize = gt.length + bq.length;
        TbCommon.long2bytes(formatId, xidInternal, offset, 8);
        TbCommon.long2bytes(gt.length, xidInternal, offset += 8, 8);
        TbCommon.long2bytes(bq.length, xidInternal, offset += 8, 8);
        System.arraycopy(gt, 0, xidInternal, offset += 8, gt.length);
        System.arraycopy(bq, 0, xidInternal, offset += gt.length, bq.length);
        offset += bq.length;
        if (realDataSize < TbXid.DATA_SIZE) {
            for (int i = 0; i < TbXid.DATA_SIZE - realDataSize; ++i) {
                xidInternal[offset] = 0;
            }
        }
    }

    public void xaCommit(Xid xid, boolean bool) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaCommitMsg = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        int flag = 0;
        flag = bool ? 0x40000000 : 0;
        xaCommitMsg.set(4, flag, xidInternal, xidInternal.length, 0);
        try {
            this.stream.sendMsg(xaCommitMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    this.doXAErrorReply(-90530, replyMsg);
                    return;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public void xaEnd(Xid xid, int flag) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaEndMsg = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        xaEndMsg.set(1, flag, xidInternal, xidInternal.length, 0);
        try {
            this.stream.sendMsg(xaEndMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    this.doXAErrorReply(-90528, replyMsg);
                    return;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public int xaForget(Xid xid) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaForget = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        xaForget.set(5, 0, xidInternal, xidInternal.length, 0);
        try {
            this.stream.sendMsg(xaForget);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    int n = 0;
                    return n;
                }
                case 76: {
                    int n = this.doXAForgetErrorReply(replyMsg);
                    return n;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public void xaOpen() throws TbSQLException {
        TbMsgXaOpen xaOpenMsg = new TbMsgXaOpen(0);
        xaOpenMsg.set(0, 500, 60, 0);
        TbMsg replyMsg = null;
        try {
            this.stream.sendMsg(xaOpenMsg);
            replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    return;
                }
            }
            throw new TbSQLException(-90402, "unsupported protocol[" + replyMsg.getMsgType() + "]");
        }
        catch (SQLException e) {
            throw new TbSQLException(-90402, "unsupported protocol[" + replyMsg.getMsgType() + "]");
        }
    }

    public int xaPrepare(Xid xid) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaPrepareMsg = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        xaPrepareMsg.set(3, 0, xidInternal, xidInternal.length, 0);
        try {
            this.stream.sendMsg(xaPrepareMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    int n = 0;
                    return n;
                }
                case 76: {
                    int n = this.doXAPrepareErrorReply(replyMsg);
                    return n;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public Xid[] xaRecover(int flag) throws TbXAException {
        TbMsgXaRecover xaRecoverMsg = new TbMsgXaRecover(0);
        try {
            this.stream.sendMsg(xaRecoverMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 70: {
                    Xid[] xidArray = this.doXARecoverOK((TbMsgXaRecoverReply)replyMsg);
                    return xidArray;
                }
                case 76: {
                    this.doXAErrorReply(-90532, replyMsg);
                    Xid[] xidArray = null;
                    return xidArray;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public void xaRollback(Xid xid) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaRollbackMsg = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        xaRollbackMsg.set(2, 0, xidInternal, xidInternal.length, 0);
        try {
            this.stream.sendMsg(xaRollbackMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    this.doXAErrorReply(-90531, replyMsg);
                    return;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    public void xaStart(Xid xid, int flag) throws TbXAException {
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        TbMsgXa xaStartMsg = new TbMsgXa(0);
        this.serializeXid(xid, xidInternal);
        xaStartMsg.set(0, flag & 0xFFFEFFFF, xidInternal, xidInternal.length, flag & 0x10000);
        try {
            this.stream.sendMsg(xaStartMsg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    this.doXAErrorReply(-90527, replyMsg);
                    return;
                }
            }
            try {
                throw new TbXAException(-6);
            }
            catch (SQLException e) {
                throw new TbXAException(-6);
            }
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }
}

