/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.MS949CharToByteConverter;
import java.sql.SQLException;

public class MS949Encoder
implements CharsetEncoder {
    private MS949CharToByteConverter conv = new MS949CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        return this.conv.convert(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        int byteIndex = destStart;
        for (int chIndex = srcStart; chIndex < srcStart + srcLen; ++chIndex) {
            if (srcChars[chIndex] < '\u0080') {
                destBytes[byteIndex++] = 0;
                destBytes[byteIndex++] = (byte)srcChars[chIndex];
                continue;
            }
            int num = this.conv.convert(srcChars, chIndex, chIndex + 1, destBytes, byteIndex, byteIndex + this.maxBytesPerChar);
            if (num == 0) {
                destBytes[byteIndex] = 0;
                destBytes[byteIndex + 1] = 0;
            } else if (num == 1) {
                destBytes[byteIndex + 1] = destBytes[byteIndex];
                destBytes[byteIndex] = 0;
            }
            byteIndex += this.maxBytesPerChar;
        }
        return byteIndex - destStart;
    }

    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (this.isEndingByte(byteArr, offset)) {
            return offset;
        }
        return offset + 1;
    }

    public int getLeadingBytePos(byte[] byteArr, int offset) {
        if (this.isLeadingByte(byteArr, offset)) {
            return offset;
        }
        return offset - 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byteArr, offset);
    }

    public boolean isLeadingByte(byte[] byteArr, int offset) {
        int i;
        for (i = offset; i >= 0 && byteArr[i] < 0; --i) {
        }
        return i == offset || (offset - i) % 2 == 1;
    }

    public byte[] stringToBytes(String srcStr) throws SQLException {
        char[] srcArr = srcStr.toCharArray();
        byte[] temp = new byte[srcArr.length * this.getMaxBytesPerChar()];
        int byteLen = this.charsToBytes(srcArr, 0, srcArr.length, temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    public byte[] stringToFixedBytes(String string) throws SQLException {
        return new byte[0];
    }
}

