/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgFetchPivotReply
extends TbMsg {
    public byte[] chunk;
    public int chunkLen;

    public TbMsgFetchPivotReply(int autoCommit) {
        this.msgType = 21;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] chunk, int chunkLen) {
        this.chunk = chunk;
        this.chunkLen = chunkLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.chunkLen != 0) {
            writer.writeInt(this.chunkLen, 4);
            writer.writePadBytes(this.chunk, 0, this.chunkLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int chunkLen = reader.readInt32();
        if (chunkLen != 0) {
            this.chunk = new byte[chunkLen];
            reader.readPadBytes(this.chunk, 0, chunkLen);
        } else {
            reader.moveReadOffset(4);
            this.chunk = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgFetchPivotReply msg = (TbMsgFetchPivotReply)obj;
        if (this.chunk == null && msg.chunk != null || this.chunk != null && msg.chunk == null) {
            return false;
        }
        if (this.chunk != null && msg.chunk != null) {
            if (this.chunk.length != msg.chunk.length) {
                return false;
            }
            for (int i = 0; i < msg.chunk.length; ++i) {
                if (this.chunk[i] == msg.chunk[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgFetchPivotReply]/");
        str.append("chunk=");
        if (this.chunk != null) {
            for (int i = 0; i < this.chunk.length; ++i) {
                str.append(this.chunk[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

