/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLongRead
extends TbMsg {
    public int len;
    public byte[] longLoc;
    public int longLocLen;

    public TbMsgLongRead(int autoCommit) {
        this.msgType = 52;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int len, byte[] longLoc, int longLocLen) {
        this.len = len;
        this.longLoc = longLoc;
        this.longLocLen = longLocLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.len, 4);
        if (this.longLocLen != 0) {
            writer.writeInt(this.longLocLen, 4);
            writer.writePadBytes(this.longLoc, 0, this.longLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.len = reader.readInt32();
        int longLocLen = reader.readInt32();
        if (longLocLen != 0) {
            this.longLoc = new byte[longLocLen];
            reader.readPadBytes(this.longLoc, 0, longLocLen);
        } else {
            reader.moveReadOffset(4);
            this.longLoc = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgLongRead msg = (TbMsgLongRead)obj;
        if (this.len != msg.len) {
            return false;
        }
        if (this.longLoc == null && msg.longLoc != null || this.longLoc != null && msg.longLoc == null) {
            return false;
        }
        if (this.longLoc != null && msg.longLoc != null) {
            if (this.longLoc.length != msg.longLoc.length) {
                return false;
            }
            for (int i = 0; i < msg.longLoc.length; ++i) {
                if (this.longLoc[i] == msg.longLoc[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgLongRead]/");
        str.append("len=");
        str.append(this.len);
        str.append("/");
        str.append("longLoc=");
        if (this.longLoc != null) {
            for (int i = 0; i < this.longLoc.length; ++i) {
                str.append(this.longLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

