/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgSessInfoReply
extends TbMsg {
    public int sessionId;
    public int serialNo;
    public String nlsDate;
    public String nlsTime;
    public String nlsTimestamp;

    public TbMsgSessInfoReply(int autoCommit) {
        this.msgType = 2;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int sessionId, int serialNo, String nlsDate, String nlsTime, String nlsTimestamp) {
        this.sessionId = sessionId;
        this.serialNo = serialNo;
        this.nlsDate = nlsDate;
        this.nlsTime = nlsTime;
        this.nlsTimestamp = nlsTimestamp;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.sessionId, 4);
        writer.writeInt(this.serialNo, 4);
        if (this.nlsDate != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsDate);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.nlsTime != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsTime);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.nlsTimestamp != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsTimestamp);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.sessionId = reader.readInt32();
        this.serialNo = reader.readInt32();
        int nlsDateLen = reader.readInt32();
        this.nlsDate = reader.readDBDecodedPadString(nlsDateLen);
        int nlsTimeLen = reader.readInt32();
        this.nlsTime = reader.readDBDecodedPadString(nlsTimeLen);
        int nlsTimestampLen = reader.readInt32();
        this.nlsTimestamp = reader.readDBDecodedPadString(nlsTimestampLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgSessInfoReply msg = (TbMsgSessInfoReply)obj;
        if (this.sessionId != msg.sessionId) {
            return false;
        }
        if (this.serialNo != msg.serialNo) {
            return false;
        }
        if (this.nlsDate == null && msg.nlsDate != null || this.nlsDate != null && msg.nlsDate == null) {
            return false;
        }
        if (this.nlsDate != null && msg.nlsDate != null && !this.nlsDate.equals(msg.nlsDate)) {
            return false;
        }
        if (this.nlsTime == null && msg.nlsTime != null || this.nlsTime != null && msg.nlsTime == null) {
            return false;
        }
        if (this.nlsTime != null && msg.nlsTime != null && !this.nlsTime.equals(msg.nlsTime)) {
            return false;
        }
        if (this.nlsTimestamp == null && msg.nlsTimestamp != null || this.nlsTimestamp != null && msg.nlsTimestamp == null) {
            return false;
        }
        return this.nlsTimestamp == null || msg.nlsTimestamp == null || this.nlsTimestamp.equals(msg.nlsTimestamp);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgSessInfoReply]/");
        str.append("sessionId=");
        str.append(this.sessionId);
        str.append("/");
        str.append("serialNo=");
        str.append(this.serialNo);
        str.append("/");
        str.append("nlsDate=");
        str.append(this.nlsDate);
        str.append("/");
        str.append("nlsTime=");
        str.append(this.nlsTime);
        str.append("/");
        str.append("nlsTimestamp=");
        str.append(this.nlsTimestamp);
        str.append("/");
        return str.append("\n").toString();
    }
}

