/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class TbGenClassUnderJDK4 {
    private static final String FILTER_OPTION = "-F";
    private static final String RESTORE_OPTION = "-R";
    private static final String TB_HOME = "TB_HOME";
    private static final String DFLT_TB_HOME = "/home/wrpark/tibero/3.1";
    private static final String beginText = "/********** since JDK1.4: begin **********/";
    private static final String endText = "/********** since JDK1.4: end ***********/";
    private static final String[] needPasringClasses = new String[]{"com.tmax.tibero.jdbc.TbConnection", "com.tmax.tibero.jdbc.TbPreparedStatement", "com.tmax.tibero.jdbc.comm.TbComm", "com.tmax.tibero.jdbc.comm.TbCommType2", "com.tmax.tibero.jdbc.comm.TbCommType4", "com.tmax.tibero.jdbc.data.DataType", "com.tmax.tibero.jdbc.ext.TbLogicalConnection"};
    private static String srcHomePath;

    public static void main(String[] args) {
        try {
            TbGenClassUnderJDK4.setSrcHomePath();
            String[] filePaths = TbGenClassUnderJDK4.getFilePaths(needPasringClasses);
            String[] backupFilePaths = TbGenClassUnderJDK4.getBackupFilePaths(filePaths);
            if (args[0].equals(FILTER_OPTION)) {
                TbGenClassUnderJDK4.backupFiles(filePaths, backupFilePaths);
                TbGenClassUnderJDK4.createFilesUnder4(backupFilePaths, filePaths);
            } else if (args[0].equals(RESTORE_OPTION)) {
                TbGenClassUnderJDK4.restoreFiles(filePaths, backupFilePaths);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setSrcHomePath() throws Exception {
        String wholeEnv = TbGenClassUnderJDK4.readEnv();
        String tbHome = TbGenClassUnderJDK4.getTbHome(wholeEnv);
        srcHomePath = tbHome + "/src/client/tbjdbc/src/";
    }

    private static String getTbHome(String env) throws Exception {
        int beginIndex = env.indexOf(TB_HOME, 0);
        int endIndex = env.indexOf(",", beginIndex);
        String tbHomeStr = env.substring(beginIndex, endIndex);
        String[] param = tbHomeStr.split("=");
        return param[1];
    }

    private static String readEnv() throws Exception {
        String command = "/usr/bin/printenv";
        String wholeEnv = new String();
        Process child = Runtime.getRuntime().exec(command);
        BufferedReader commandResult = new BufferedReader(new InputStreamReader(child.getInputStream()));
        String line = null;
        while ((line = commandResult.readLine()) != null) {
            wholeEnv = wholeEnv + "," + line;
        }
        if (child.waitFor() != 0) {
            throw new Exception("Error=Cannot complete OSEnvironment.class: " + command + ":" + child.exitValue());
        }
        return wholeEnv;
    }

    private static String[][] parseEnv(String wholeEnv) {
        int envDataSize = 0;
        StringTokenizer envTokenizer = new StringTokenizer(wholeEnv, ",", false);
        envDataSize = envTokenizer.countTokens();
        String[][] parsedEnv = new String[envDataSize][2];
        for (int i = 0; i < envDataSize; ++i) {
            if (!envTokenizer.hasMoreTokens()) continue;
            String singlePair = envTokenizer.nextToken();
            parsedEnv[i][0] = singlePair.substring(0, singlePair.indexOf("="));
            parsedEnv[i][1] = singlePair.substring(singlePair.indexOf("=") + 1);
        }
        return parsedEnv;
    }

    private static String getEnvValue(String envName, String defaultValue, String[][] envData) {
        String valueFound = defaultValue;
        for (int i = 0; i < envData.length; ++i) {
            if (!envData[i][0].equals(envName)) continue;
            valueFound = envData[i][1];
        }
        return valueFound;
    }

    private static void createFilesUnder4(String[] srcFilePaths, String[] dstFilePaths) throws IOException {
        for (int i = 0; i < srcFilePaths.length; ++i) {
            File srcFile = new File(srcFilePaths[i]);
            File dstFile = new File(dstFilePaths[i]);
            TbGenClassUnderJDK4.copyAndFilterText(srcFile, dstFile);
        }
    }

    private static void copyAndFilterText(File srcFile, File dstFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(srcFile)));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dstFile)));
        String textLine = null;
        boolean isTextOver4 = false;
        while ((textLine = reader.readLine()) != null) {
            if (textLine.indexOf(beginText) != -1) {
                isTextOver4 = true;
                continue;
            }
            if (textLine.indexOf(endText) != -1) {
                isTextOver4 = false;
                continue;
            }
            if (isTextOver4) continue;
            writer.write(textLine);
            writer.write("\n");
        }
        reader.close();
        writer.close();
    }

    private static String[] getFilePaths(String[] classNames) {
        String[] filePaths = new String[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            filePaths[i] = srcHomePath + classNames[i].replace('.', '/') + ".java";
        }
        return filePaths;
    }

    private static String[] getBackupFilePaths(String[] filePaths) {
        String[] tmpFilePaths = new String[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            tmpFilePaths[i] = filePaths[i] + ".tmp";
        }
        return tmpFilePaths;
    }

    private static void backupFiles(String[] filePaths, String[] backupFilePaths) throws Exception {
        for (int i = 0; i < filePaths.length; ++i) {
            String[] cmdArray = new String[]{"/bin/cp", filePaths[i], backupFilePaths[i]};
            Process child = Runtime.getRuntime().exec(cmdArray);
            if (child.waitFor() == 0) continue;
            throw new Exception("cannot backup files because execute command:" + cmdArray);
        }
    }

    private static void restoreFiles(String[] filePaths, String[] backupFilePaths) throws Exception {
        for (int i = 0; i < filePaths.length; ++i) {
            String[] cmdArray = new String[]{"/bin/mv", backupFilePaths[i], filePaths[i]};
            Process child = Runtime.getRuntime().exec(cmdArray);
            if (child.waitFor() == 0) continue;
            throw new Exception("cannot backup files because execute command:" + cmdArray);
        }
    }
}

