/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.rowset;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class TbRow
implements Serializable,
Cloneable {
    protected Object[] originalCols;
    protected Object[] currentCols;
    protected boolean[] isColChanged;
    protected boolean deleted;
    protected boolean updated;
    protected boolean inserted;
    protected int columnCnt;

    public void reset() {
        this.originalCols = null;
        this.currentCols = null;
        this.isColChanged = null;
        this.deleted = false;
        this.updated = false;
        this.inserted = false;
        this.columnCnt = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public TbRow(int columnCnt) {
        this.originalCols = new Object[columnCnt];
        this.currentCols = new Object[columnCnt];
        this.isColChanged = new boolean[columnCnt];
        this.columnCnt = columnCnt;
    }

    public TbRow(int columnCnt, Object[] cols) {
        this(columnCnt);
        System.arraycopy(cols, 0, this.originalCols, 0, columnCnt);
    }

    public void markInserted() {
        this.inserted = true;
    }

    public void markInserted(int columnIndex) {
        this.inserted = true;
        this.isColChanged[columnIndex - 1] = true;
    }

    public void markDeleted() {
        this.deleted = true;
    }

    public void markUpdated() {
        this.updated = true;
    }

    public void markUpdated(int columnIndex) {
        this.updated = true;
        this.isColChanged[columnIndex - 1] = true;
    }

    public void cancelInserted() {
        this.inserted = false;
    }

    public void cancelDeleted() {
        this.deleted = false;
    }

    public void cancelUpdated() {
        this.updated = false;
        for (int k = 0; k < this.columnCnt; ++k) {
            this.isColChanged[k] = false;
            this.currentCols[k] = null;
        }
    }

    public boolean isColumnChanged(int columnIndex) {
        return this.isColChanged[columnIndex - 1];
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public Object getColumn(int columnIndex) {
        if (this.isColumnChanged(columnIndex)) {
            return this.currentCols[columnIndex - 1];
        }
        return this.originalCols[columnIndex - 1];
    }

    public void setColumn(int columnIndex, Object obj) {
        this.markUpdated(columnIndex);
        this.currentCols[columnIndex - 1] = obj;
    }

    public void insertColumn(int columnIndex, Object obj) {
        this.markInserted(columnIndex);
        this.currentCols[columnIndex - 1] = obj;
    }

    public Object[] getOriginalColumns() {
        return this.originalCols;
    }

    public void commitChangedColumns() {
        for (int k = 0; k < this.columnCnt; ++k) {
            if (!this.isColChanged[k]) continue;
            this.originalCols[k] = this.currentCols[k];
            this.currentCols[k] = null;
            this.isColChanged[k] = false;
        }
        this.inserted = false;
        this.updated = false;
    }

    public Collection toCollection() {
        Vector<Object> cols = new Vector<Object>(this.columnCnt);
        for (int k = 0; k < this.columnCnt; ++k) {
            if (this.isColChanged[k]) {
                cols.add(this.currentCols[k]);
                continue;
            }
            cols.add(this.originalCols[k]);
        }
        return cols;
    }
}

