/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.data.MappingInfo;
import egovframework.rte.itl.webservice.data.WebServiceClientDefinition;
import egovframework.rte.itl.webservice.service.ServiceEndpointInterfaceInfo;
import egovframework.rte.itl.webservice.service.ServiceParamInfo;
import egovframework.rte.itl.webservice.service.impl.ServiceParamInfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointInterfaceInfoImpl
implements ServiceEndpointInterfaceInfo {
    private Log LOG = LogFactory.getLog(this.getClass());
    private String namespace;
    private String wsdlAddress;
    private String serviceName;
    private String portName;
    private String operationName;
    private ServiceParamInfo returnInfo;
    private Collection<ServiceParamInfo> paramInfos;

    public ServiceEndpointInterfaceInfoImpl(String namespace, String wsdlAddress, String serviceName, String portName, String operationName, ServiceParamInfo returnInfo, Collection<ServiceParamInfo> paramInfos) {
        if (!StringUtils.hasText((String)namespace)) {
            this.LOG.error((Object)("Argument 'namespace' has no text (" + namespace + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)wsdlAddress)) {
            this.LOG.error((Object)("Argument 'wsdlAddress' has no text (" + wsdlAddress + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)serviceName)) {
            this.LOG.error((Object)("Argument 'serviceName' has no text (" + serviceName + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)portName)) {
            this.LOG.error((Object)("Argument 'portName' has no text (" + portName + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)operationName)) {
            this.LOG.error((Object)("Argument 'operationName' has no text (" + operationName + ")"));
            throw new IllegalArgumentException();
        }
        if (paramInfos == null) {
            this.LOG.error((Object)"Argument 'paramInfos' is null");
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
        this.wsdlAddress = wsdlAddress;
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.returnInfo = returnInfo;
        this.paramInfos = paramInfos;
    }

    public ServiceEndpointInterfaceInfoImpl(WebServiceClientDefinition webServiceClientDefinition, RecordType requestType, RecordType responseType) {
        if (webServiceClientDefinition == null) {
            this.LOG.error((Object)"Argument 'webServiceClientDefinition' is null");
            throw new IllegalArgumentException();
        }
        if (!webServiceClientDefinition.isValid()) {
            this.LOG.error((Object)"Argument 'webServiceClientDefinition' is invalid");
            throw new IllegalArgumentException();
        }
        if (requestType == null) {
            this.LOG.error((Object)"Argument 'requestType' is null");
            throw new IllegalArgumentException();
        }
        if (responseType == null) {
            this.LOG.error((Object)"Argument 'responseType' is null");
            throw new IllegalArgumentException();
        }
        this.namespace = webServiceClientDefinition.getNamespace();
        this.wsdlAddress = webServiceClientDefinition.getWsdlAddress();
        this.serviceName = webServiceClientDefinition.getServiceName();
        this.portName = webServiceClientDefinition.getPortName();
        this.operationName = webServiceClientDefinition.getOperationName();
        if (webServiceClientDefinition.getServiceDefinition().isStandard()) {
            this.paramInfos = new ArrayList<ServiceParamInfo>();
            this.paramInfos.add(new ServiceParamInfoImpl("header", EgovWebServiceMessageHeader.TYPE, WebParam.Mode.INOUT, true));
            for (Map.Entry entry : requestType.getFieldTypes().entrySet()) {
                this.paramInfos.add(new ServiceParamInfoImpl((String)entry.getKey(), (Type)entry.getValue(), WebParam.Mode.IN, false));
            }
            for (Map.Entry entry : responseType.getFieldTypes().entrySet()) {
                this.paramInfos.add(new ServiceParamInfoImpl((String)entry.getKey(), (Type)entry.getValue(), WebParam.Mode.OUT, false));
            }
        } else {
            ServiceParamInfoImpl paramInfo;
            Type fieldType;
            MappingInfo mappingInfo;
            String fieldName;
            HashMap<String, ServiceParamInfoImpl> paramInfoMap = new HashMap<String, ServiceParamInfoImpl>();
            if (webServiceClientDefinition.getRequestMappingInfos() != null) {
                for (Map.Entry<String, MappingInfo> entry : webServiceClientDefinition.getRequestMappingInfos().entrySet()) {
                    fieldName = entry.getKey();
                    mappingInfo = entry.getValue();
                    fieldType = requestType.getFieldType(fieldName);
                    paramInfo = new ServiceParamInfoImpl(fieldName, fieldType, WebParam.Mode.IN, mappingInfo.isHeader());
                    paramInfoMap.put(fieldName, paramInfo);
                }
            }
            if (webServiceClientDefinition.getResponseMappingInfos() != null) {
                for (Map.Entry<String, MappingInfo> entry : webServiceClientDefinition.getResponseMappingInfos().entrySet()) {
                    fieldName = entry.getKey();
                    mappingInfo = entry.getValue();
                    fieldType = responseType.getFieldType(fieldName);
                    paramInfo = (ServiceParamInfoImpl)paramInfoMap.get(fieldName);
                    if (paramInfo != null) {
                        if (paramInfo.isHeader() == mappingInfo.isHeader()) {
                            paramInfo.getType().equals(fieldType);
                            paramInfo.setMode(WebParam.Mode.INOUT);
                        } else {
                            paramInfo = null;
                        }
                    }
                    if (paramInfo != null) continue;
                    paramInfo = new ServiceParamInfoImpl(fieldName, fieldType, WebParam.Mode.OUT, mappingInfo.isHeader());
                    paramInfoMap.put(fieldName, paramInfo);
                }
            }
            this.returnInfo = null;
            this.paramInfos = paramInfoMap.values();
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getWsdlAddress() {
        return this.wsdlAddress;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public ServiceParamInfo getReturnInfo() {
        return this.returnInfo;
    }

    @Override
    public Collection<ServiceParamInfo> getParamInfos() {
        return this.paramInfos;
    }
}

