/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABPreparedStatement;
import Altibase.jdbc.driver.ABRConnection;
import Altibase.jdbc.driver.Blob;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class ABRPreparedStatement
extends ABPreparedStatement {
    static final long serialVersionUID = 3L;
    protected PreparedStatement sstmt;

    public ABRPreparedStatement(ABRConnection c, String sql) throws SQLException {
        super(c, sql);
        this.sstmt = c.s_con.prepareStatement(sql);
    }

    public ABRPreparedStatement(ABRConnection c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(c, sql, resultSetType, resultSetConcurrency);
        this.sstmt = c.s_con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public boolean execute() throws SQLException {
        boolean ret = false;
        if (super.execute()) {
            ret = true;
        } else {
            this.sstmt.execute();
        }
        if (!ret && ((ABRConnection)this.mConnection).autocommit) {
            ((ABRConnection)this.mConnection).s_con.commit();
            this.mConnection.commit();
        }
        return ret;
    }

    public int[] executeBatch() throws SQLException {
        int[] ret = super.executeBatch();
        int[] slv = this.sstmt.executeBatch();
        return ret;
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        return super.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        int ret;
        try {
            ret = super.executeUpdate();
            int srt = this.sstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            this.mConnection.rollback();
            throw e;
        }
        if (((ABRConnection)this.mConnection).autocommit) {
            ((ABRConnection)this.mConnection).s_con.commit();
            this.mConnection.commit();
        }
        return ret;
    }

    public void setAsciiStream(int idx, InputStream in, int len) throws SQLException {
        super.setAsciiStream(idx, in, len);
        this.sstmt.setAsciiStream(idx, in, len);
    }

    public void setBigDecimal(int idx, BigDecimal d) throws SQLException {
        super.setBigDecimal(idx, d);
        this.sstmt.setBigDecimal(idx, d);
    }

    public void setBinaryStream(int idx, InputStream in, int len) throws SQLException {
        super.setBinaryStream(idx, in, len);
        this.sstmt.setBinaryStream(idx, in, len);
    }

    public void setBlob(int idx, Blob x) throws SQLException {
        super.setBlob(idx, x);
        this.sstmt.setBlob(idx, x);
    }

    public void setBoolean(int idx, boolean b) throws SQLException {
        super.setBoolean(idx, b);
        this.sstmt.setBoolean(idx, b);
    }

    public void setByte(int idx, byte b) throws SQLException {
        super.setByte(idx, b);
        this.sstmt.setByte(idx, b);
    }

    public void setBytes(int idx, byte[] data) throws SQLException {
        super.setBytes(idx, data);
        this.sstmt.setBytes(idx, data);
    }

    public void setCharacterStream(int idx, Reader in, int len) throws SQLException {
        super.setCharacterStream(idx, in, len);
        this.sstmt.setCharacterStream(idx, in, len);
    }

    public void setDate(int idx, Date d) throws SQLException {
        super.setDate(idx, d);
        this.sstmt.setDate(idx, d);
    }

    public void setDouble(int idx, double d) throws SQLException {
        super.setDouble(idx, d);
        this.sstmt.setDouble(idx, d);
    }

    public void setFloat(int idx, float f) throws SQLException {
        super.setFloat(idx, f);
        this.sstmt.setFloat(idx, f);
    }

    public void setInt(int idx, int x) throws SQLException {
        super.setInt(idx, x);
        this.sstmt.setInt(idx, x);
    }

    public void setLong(int idx, long l) throws SQLException {
        super.setLong(idx, l);
        this.sstmt.setLong(idx, l);
    }

    public void setNull(int idx, int type) throws SQLException {
        super.setNull(idx, type);
        this.sstmt.setNull(idx, type);
    }

    public void setNull(int idx, int type, String tname) throws SQLException {
        super.setNull(idx, type, tname);
        this.sstmt.setNull(idx, type, tname);
    }

    public void setObject(int idx, Object ob) throws SQLException {
        super.setObject(idx, ob);
        this.sstmt.setObject(idx, ob);
    }

    public void setObject(int idx, Object o, int type) throws SQLException {
        super.setObject(idx, o, type);
        this.sstmt.setObject(idx, o, type);
    }

    public void setObject(int idx, Object o, int type, int scale) throws SQLException {
        super.setObject(idx, o, type, scale);
        this.sstmt.setObject(idx, o, type, scale);
    }

    public void setShort(int idx, short s) throws SQLException {
        super.setShort(idx, s);
        this.sstmt.setShort(idx, s);
    }

    public void setString(int idx, String str) throws SQLException {
        super.setString(idx, str);
        this.sstmt.setString(idx, str);
    }

    public void setTime(int idx, Time t) throws SQLException {
        super.setTime(idx, t);
        this.sstmt.setTime(idx, t);
    }

    public void setTimestamp(int idx, Timestamp t) throws SQLException {
        super.setTimestamp(idx, t);
        this.sstmt.setTimestamp(idx, t);
    }
}

