/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.BindMeta;
import Altibase.jdbc.driver.LobUpdater;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ABResultSetMetaData
extends ArrayList
implements ResultSetMetaData,
SQLStates {
    static final long serialVersionUID = 1L;
    protected ABStatement mStatement;
    protected int mCurrentBufferNo;
    protected boolean mExecuteReady;
    protected short mLastGetterColPos;
    protected short mLastPosition;
    protected short mCurrentPos;
    protected short mCurrentSize;
    protected HashMap mLobUpdater;
    protected boolean mChangedBindInfo;

    ABResultSetMetaData(ABStatement aStatement) throws SQLException {
        super.add(null);
        this.mStatement = aStatement;
        this.mLastGetterColPos = 0;
        this.mCurrentPos = 0;
        this.mCurrentSize = 0;
        this.mExecuteReady = false;
        this.mChangedBindInfo = false;
        this.mLobUpdater = new HashMap();
    }

    final void allocAndAddMetaColumn(BindMeta bm) throws SQLException {
        bm.reAlloc();
        bm.setEncoder(this.mStatement.getEncoder());
        this.addMetaColumn(bm);
    }

    final void addMetaColumn(BindMeta aBindMeta) throws SQLException {
        super.add(aBindMeta.mColumnNo, aBindMeta);
    }

    public Object clone() {
        ABResultSetMetaData ret = (ABResultSetMetaData)super.clone();
        return ret;
    }

    public String getCatalogName(int c) throws SQLException {
        return "";
    }

    public String getColumnClassName(int c) throws SQLException {
        return this.getMetaColumn(c).getClassName();
    }

    public int getColumnCount() {
        return this.size() - 1;
    }

    public int getColumnDisplaySize(int c) throws SQLException {
        return this.getMetaColumn(c).getDisplaySize();
    }

    public String getColumnLabel(int c) throws SQLException {
        return this.getMetaColumn(c).getLable();
    }

    public String getColumnName(int c) throws SQLException {
        return this.getMetaColumn(c).getName();
    }

    public int getColumnType(int c) throws SQLException {
        return this.getMetaColumn(c).getType();
    }

    public String getColumnTypeName(int c) throws SQLException {
        return this.getMetaColumn(c).getTypeName();
    }

    public int getPrecision(int c) throws SQLException {
        return this.getMetaColumn(c).getPrecision();
    }

    public int getScale(int c) throws SQLException {
        return this.getMetaColumn(c).getScale();
    }

    public String getSchemaName(int column) throws SQLException {
        return ((ABConnection)this.mStatement.getConnection()).getUser();
    }

    public String getTableName(int c) throws SQLException {
        return this.getMetaColumn(c).getTableName();
    }

    public boolean isAutoIncrement(int c) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int c) throws SQLException {
        return true;
    }

    public boolean isCurrency(int c) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int c) throws SQLException {
        return this.getMetaColumn(c).isWritable();
    }

    public int isNullable(int c) throws SQLException {
        return this.getMetaColumn(c).isNullable();
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isSearchable(int c) throws SQLException {
        return true;
    }

    public boolean isSigned(int column) throws SQLException {
        switch (this.getColumnType(column)) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isWritable(int c) throws SQLException {
        return this.getMetaColumn(c).isWritable();
    }

    void executeLobUpdate() throws SQLException {
        Iterator e = this.mLobUpdater.values().iterator();
        while (e.hasNext()) {
            LobUpdater updater = (LobUpdater)e.next();
            updater.doExecute();
        }
        this.mCurrentPos = 0;
    }

    final void allocNewFetchBuffer(ArrayList list) throws SQLException {
        Object[] sNewBuffer = new Object[this.getColumnCount() + 1];
        sNewBuffer[0] = super.set(0, null);
        for (int i = 1; i < sNewBuffer.length; ++i) {
            sNewBuffer[i] = ((BindMeta)super.get(i)).reAlloc();
        }
        list.add(sNewBuffer);
        this.mCurrentBufferNo = list.size();
    }

    final void readBufferIntoMetaData(ArrayList list, int aBufferNo) throws SQLException {
        if (this.mCurrentBufferNo != aBufferNo) {
            Object[] row = (Object[])list.get(aBufferNo);
            super.set(0, row[0]);
            for (int i = 1; i < row.length; ++i) {
                ((BindMeta)super.get(i)).replaceData((ArrayList)row[i]);
            }
        }
    }

    boolean sendBindInfo(cmp aChn) throws SQLException {
        boolean sUpdate = this.mExecuteReady;
        if (this.mExecuteReady) {
            if (this.mChangedBindInfo) {
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    this.getMetaColumn((int)i).mIsBindInfoParam = true;
                }
            }
            for (int j = 1; j <= this.getColumnCount(); ++j) {
                ex.test(this.getMetaColumn(j).getInOutType() == 0, (short)97);
                this.getMetaColumn(j).writeBindProtocol(aChn, this.getStmtID());
            }
            this.mExecuteReady = false;
        }
        return sUpdate;
    }

    void getModeOut(int c) throws SQLException {
        this.mExecuteReady |= this.getMetaColumn(c).modeOut();
    }

    final short reset() {
        this.mCurrentPos = 0;
        return this.mCurrentSize;
    }

    void clearArray() throws SQLException {
        this.mCurrentPos = 0;
        this.mCurrentSize = 0;
        for (int i = this.getColumnCount(); i > 0; --i) {
            this.getMetaColumn(i).setNull(this.mCurrentPos);
        }
    }

    final short getCurrentSize() {
        return this.mCurrentSize;
    }

    final short getNextPos() {
        this.mCurrentPos = (short)(this.mCurrentPos + 1);
        this.mCurrentPos = (short)(this.mCurrentPos % this.mCurrentSize);
        return this.mCurrentPos;
    }

    final ABEncoder getEncoder() {
        return this.mStatement.getEncoder();
    }

    void registerOutParameter(int i, int type) throws SQLException {
        BindMeta bm = this.getMetaColumn(i);
        bm.setSQLType(type);
        bm.modeOut();
        this.mCurrentSize = this.mCurrentPos;
        this.mCurrentSize = (short)(this.mCurrentSize + 1);
        bm.setEncoder(this.mStatement.getEncoder());
    }

    final short getCurrentPos() {
        return this.mCurrentPos;
    }

    void setColumnName(int c, String name) throws SQLException {
        this.getMetaColumn(c).setColumnName(name);
    }

    final int getStmtID() {
        return this.mStatement.getID();
    }

    BindMeta getMetaColumn(int aColNo) throws SQLException {
        try {
            BindMeta ret = (BindMeta)super.get(aColNo);
            this.mLastGetterColPos = (short)aColNo;
            return ret;
        }
        catch (Exception e) {
            ex.exception((short)21);
            return null;
        }
    }

    int getColumnNo(String name) throws SQLException {
        for (int i = 1; i < this.size(); ++i) {
            if (!name.equalsIgnoreCase(this.getMetaColumn(i).getName())) continue;
            return i;
        }
        ex.exception((short)21, SQLStates.mFixmsg[22] + name + SQLStates.mFixmsg[23]);
        return -1;
    }

    final void initLastGetterColPos() {
        this.mLastGetterColPos = 0;
    }

    final short getLastGetterColPos() {
        return this.mLastGetterColPos;
    }
}

