/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends Type {
    private static final Log LOG = LogFactory.getLog(ArrayType.class);
    private QName componentName;
    private long minOccurs;
    private long maxOccurs = Long.MAX_VALUE;
    private boolean flat;

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        try {
            Collection values = this.readCollection(reader, context);
            return this.makeArray(this.getComponentType().getTypeClass(), values);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    protected Collection<Object> createCollection() {
        return new ArrayList<Object>();
    }

    protected Collection readCollection(MessageReader reader, Context context) throws DatabindingException {
        Collection<Object> values = this.createCollection();
        while (reader.hasMoreElementReaders()) {
            int size;
            MessageReader creader = reader.getNextElementReader();
            Type compType = TypeUtil.getReadType(creader.getXMLStreamReader(), context.getGlobalContext(), this.getComponentType());
            if (creader.isXsiNil()) {
                values.add(null);
                creader.readToEnd();
            } else {
                values.add(compType.readObject(creader, context));
            }
            if ((long)(size = values.size()) <= this.maxOccurs) continue;
            throw new DatabindingException("The number of elements in " + this.getSchemaType() + " exceeds the maximum of " + this.maxOccurs);
        }
        if ((long)values.size() < this.minOccurs) {
            throw new DatabindingException("The number of elements in " + this.getSchemaType() + " does not meet the minimum of " + this.minOccurs);
        }
        return values;
    }

    protected Object makeArray(Class arrayType, Collection values) {
        Object array;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        array = null;
                                        if (!Integer.TYPE.equals(arrayType)) break block8;
                                        Object[] objects = values.toArray();
                                        array = Array.newInstance(Integer.TYPE, objects.length);
                                        int n = objects.length;
                                        for (int i = 0; i < n; ++i) {
                                            Array.set(array, i, objects[i]);
                                        }
                                        break block9;
                                    }
                                    if (!Long.TYPE.equals(arrayType)) break block10;
                                    Object[] objects = values.toArray();
                                    array = Array.newInstance(Long.TYPE, objects.length);
                                    int n = objects.length;
                                    for (int i = 0; i < n; ++i) {
                                        Array.set(array, i, objects[i]);
                                    }
                                    break block9;
                                }
                                if (!Short.TYPE.equals(arrayType)) break block11;
                                Object[] objects = values.toArray();
                                array = Array.newInstance(Short.TYPE, objects.length);
                                int n = objects.length;
                                for (int i = 0; i < n; ++i) {
                                    Array.set(array, i, objects[i]);
                                }
                                break block9;
                            }
                            if (!Double.TYPE.equals(arrayType)) break block12;
                            Object[] objects = values.toArray();
                            array = Array.newInstance(Double.TYPE, objects.length);
                            int n = objects.length;
                            for (int i = 0; i < n; ++i) {
                                Array.set(array, i, objects[i]);
                            }
                            break block9;
                        }
                        if (!Float.TYPE.equals(arrayType)) break block13;
                        Object[] objects = values.toArray();
                        array = Array.newInstance(Float.TYPE, objects.length);
                        int n = objects.length;
                        for (int i = 0; i < n; ++i) {
                            Array.set(array, i, objects[i]);
                        }
                        break block9;
                    }
                    if (!Byte.TYPE.equals(arrayType)) break block14;
                    Object[] objects = values.toArray();
                    array = Array.newInstance(Byte.TYPE, objects.length);
                    int n = objects.length;
                    for (int i = 0; i < n; ++i) {
                        Array.set(array, i, objects[i]);
                    }
                    break block9;
                }
                if (!Boolean.TYPE.equals(arrayType)) break block15;
                Object[] objects = values.toArray();
                array = Array.newInstance(Boolean.TYPE, objects.length);
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    Array.set(array, i, objects[i]);
                }
                break block9;
            }
            if (!Character.TYPE.equals(arrayType)) break block9;
            Object[] objects = values.toArray();
            array = Array.newInstance(Character.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
        }
        return array == null ? values.toArray((Object[])Array.newInstance(this.getComponentType().getTypeClass(), values.size())) : array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object values, MessageWriter writer, Context context) throws DatabindingException {
        boolean forceXsiWrite = false;
        if (values == null) {
            return;
        }
        Type type = this.getComponentType();
        if (type == null) {
            throw new DatabindingException("Couldn't find type for array.");
        }
        if (XmlSchemaConstants.ANY_TYPE_QNAME.equals(type.getSchemaType())) {
            forceXsiWrite = true;
        }
        String ns = null;
        ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
        String name = type.getSchemaType().getLocalPart();
        Class arrayType = type.getTypeClass();
        boolean oldXsiWrite = context.getGlobalContext().isWriteXsiTypes();
        try {
            if (forceXsiWrite) {
                context.getGlobalContext().setWriteXsiTypes(true);
            }
            if (Object.class.isAssignableFrom(arrayType)) {
                Object[] objects = (Object[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(objects[i], writer, context, type, name, ns);
                }
            } else if (Integer.TYPE.equals(arrayType)) {
                int[] objects = (int[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Integer(objects[i]), writer, context, type, name, ns);
                }
            } else if (Long.TYPE.equals(arrayType)) {
                long[] objects = (long[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Long(objects[i]), writer, context, type, name, ns);
                }
            } else if (Short.TYPE.equals(arrayType)) {
                short[] objects = (short[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Short(objects[i]), writer, context, type, name, ns);
                }
            } else if (Double.TYPE.equals(arrayType)) {
                double[] objects = (double[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Double(objects[i]), writer, context, type, name, ns);
                }
            } else if (Float.TYPE.equals(arrayType)) {
                float[] objects = (float[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Float(objects[i]), writer, context, type, name, ns);
                }
            } else if (Byte.TYPE.equals(arrayType)) {
                byte[] objects = (byte[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Byte(objects[i]), writer, context, type, name, ns);
                }
            } else if (Boolean.TYPE.equals(arrayType)) {
                boolean[] objects = (boolean[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(objects[i], writer, context, type, name, ns);
                }
            } else if (Character.TYPE.equals(arrayType)) {
                char[] objects = (char[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Character(objects[i]), writer, context, type, name, ns);
                }
            }
        }
        finally {
            context.getGlobalContext().setWriteXsiTypes(oldXsiWrite);
        }
    }

    protected void writeValue(Object value, MessageWriter writer, Context context, Type type, String name, String ns) throws DatabindingException {
        type = TypeUtil.getWriteType(context.getGlobalContext(), value, type);
        MessageWriter cwriter = type.isWriteOuter() ? writer.getElementWriter(name, ns) : writer;
        if (value == null && type.isNillable()) {
            cwriter.writeXsiNil();
        } else {
            type.writeObject(value, cwriter, context);
        }
        if (type.isWriteOuter()) {
            cwriter.close();
        }
    }

    @Override
    public void writeSchema(XmlSchema root) {
        if (this.hasDefinedArray(root)) {
            return;
        }
        XmlSchemaComplexType complex = new XmlSchemaComplexType(root);
        complex.setName(this.getSchemaType().getLocalPart());
        root.addType((XmlSchemaType)complex);
        root.getItems().add((XmlSchemaObject)complex);
        XmlSchemaSequence seq = new XmlSchemaSequence();
        complex.setParticle((XmlSchemaParticle)seq);
        Type componentType = this.getComponentType();
        XmlSchemaElement element = new XmlSchemaElement();
        element.setName(componentType.getSchemaType().getLocalPart());
        element.setSchemaTypeName(componentType.getSchemaType());
        seq.getItems().add((XmlSchemaObject)element);
        if (componentType.isNillable()) {
            element.setNillable(true);
        }
        element.setMinOccurs(this.getMinOccurs());
        element.setMaxOccurs(this.getMaxOccurs());
    }

    private boolean hasDefinedArray(XmlSchema root) {
        return root.getTypeByName(this.getSchemaType().getLocalPart()) != null;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    @Override
    public Set<Type> getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    public Type getComponentType() {
        Type type;
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            type = this.getTypeMapping().getType(compType);
        } else {
            type = this.getTypeMapping().getType(this.componentName);
            if (type == null) {
                LOG.debug((Object)("Couldn't find array component type " + this.componentName + ". Creating one instead."));
            }
        }
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(compType);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    @Override
    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(long maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public long getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(long minOccurs) {
        this.minOccurs = minOccurs;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.setWriteOuter(!flat);
        this.flat = flat;
    }

    @Override
    public boolean hasMaxOccurs() {
        return true;
    }

    @Override
    public boolean hasMinOccurs() {
        return true;
    }
}

