/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.functions.FinanceLib;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public abstract class FinanceFunction
extends NumericFunction.MultiArg {
    public static final Function FV = new FinanceFunction(){

        protected double evaluate(double rate, double arg1, double arg2, double arg3, boolean type) {
            return FinanceLib.fv(rate, arg1, arg2, arg3, type);
        }
    };
    public static final Function NPER = new FinanceFunction(){

        protected double evaluate(double rate, double arg1, double arg2, double arg3, boolean type) {
            return FinanceLib.nper(rate, arg1, arg2, arg3, type);
        }
    };
    public static final Function PMT = new FinanceFunction(){

        protected double evaluate(double rate, double arg1, double arg2, double arg3, boolean type) {
            return FinanceLib.pmt(rate, arg1, arg2, arg3, type);
        }
    };
    public static final Function PV = new FinanceFunction(){

        protected double evaluate(double rate, double arg1, double arg2, double arg3, boolean type) {
            return FinanceLib.pv(rate, arg1, arg2, arg3, type);
        }
    };

    protected FinanceFunction() {
        super(3, 5);
    }

    protected double evaluate(double[] ds) throws EvaluationException {
        double arg3 = 0.0;
        double arg4 = 0.0;
        switch (ds.length) {
            case 5: {
                arg4 = ds[4];
            }
            case 4: {
                arg3 = ds[3];
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Wrong number of arguments");
            }
        }
        return this.evaluate(ds[0], ds[1], ds[2], arg3, arg4 != 0.0);
    }

    protected abstract double evaluate(double var1, double var3, double var5, double var7, boolean var9) throws EvaluationException;
}

