/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderImpl<T>
extends JAXBDataBase
implements DataReader<T> {
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    JAXBDataBinding databinding;

    public DataReaderImpl(JAXBDataBinding binding) {
        super(binding.getContext());
        this.databinding = binding;
    }

    public Object read(T input) {
        return this.read(null, input);
    }

    private Unmarshaller createUnmarshaller() {
        try {
            Unmarshaller um = null;
            um = this.context.createUnmarshaller();
            if (this.databinding.getUnmarshallerListener() != null) {
                um.setListener(this.databinding.getUnmarshallerListener());
            }
            if (this.databinding.getValidationEventHandler() != null) {
                um.setEventHandler(this.databinding.getValidationEventHandler());
            }
            if (this.databinding.getUnmarshallerProperties() != null) {
                for (Map.Entry<String, Object> propEntry : this.databinding.getUnmarshallerProperties().entrySet()) {
                    try {
                        um.setProperty(propEntry.getKey(), propEntry.getValue());
                    }
                    catch (PropertyException pe) {
                        LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                    }
                }
            }
            um.setSchema(this.schema);
            um.setAttachmentUnmarshaller(this.getAttachmentUnmarshaller());
            return um;
        }
        catch (JAXBException ex) {
            if (ex instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex;
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{unmarshalEx.getLinkedException().getMessage()}), (Throwable)ex);
            }
            throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public Object read(MessagePartInfo part, T reader) {
        boolean honorJaxbAnnotation = false;
        if (part != null && part.getProperty("honor.jaxb.annotations") != null) {
            honorJaxbAnnotation = (Boolean)part.getProperty("honor.jaxb.annotations");
        }
        Annotation[] anns = this.getJAXBAnnotation(part);
        if (honorJaxbAnnotation && anns.length > 0) {
            QName qname = new QName(null, part.getConcreteName().getLocalPart());
            return JAXBEncoderDecoder.unmarshalWithBridge(qname, part.getTypeClass(), anns, this.databinding.getContextClasses(), reader, this.getAttachmentUnmarshaller());
        }
        return JAXBEncoderDecoder.unmarshall(this.createUnmarshaller(), reader, part, this.unwrapJAXBElement);
    }

    public Object read(QName name, T input, Class type) {
        return JAXBEncoderDecoder.unmarshall(this.createUnmarshaller(), input, name, type, this.unwrapJAXBElement);
    }
}

