/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.crypto;

import egovframework.rte.fdl.crypto.CryptoConfig;
import egovframework.rte.fdl.crypto.CryptoLog;
import org.apache.log4j.Logger;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class EgovPasswordLoad {
    ConfigurablePasswordEncryptor passwordEncryptor = new ConfigurablePasswordEncryptor();
    private static Logger logger = CryptoLog.getLogger(EgovPasswordLoad.class);
    ApplicationContext context = new FileSystemXmlApplicationContext(this.default_path);
    String default_path = "classpath*:spring/context-config.xml";
    CryptoConfig cryptoConfig = (CryptoConfig)this.context.getBean("config");

    public EgovPasswordLoad() {
        String pwdAlgorithm = this.cryptoConfig.getPasswordAlgorithm();
        if (pwdAlgorithm.trim().length() <= 0) {
            this.passwordEncryptor.setAlgorithm("SHA-1");
        } else {
            this.passwordEncryptor.setAlgorithm(pwdAlgorithm);
        }
        this.passwordEncryptor.setPlainDigest(true);
    }

    public String encrypt(String str) {
        String rtn_str = this.passwordEncryptor.encryptPassword(str);
        return rtn_str;
    }

    public boolean checkPassword(String planPD, String cryptoPD) {
        return this.passwordEncryptor.checkPassword(planPD, cryptoPD);
    }

    public void debug(String str) {
        logger.debug((Object)str);
    }

    public static void main(String[] args) {
        EgovPasswordLoad epl = new EgovPasswordLoad();
        String str = epl.encrypt("Egov");
        epl.debug(str);
        if (epl.checkPassword("Egov", str)) {
            epl.debug("\uc77c\uce58\ud569\ub2c8\ub2e4.");
        } else {
            epl.debug("\uc77c\uce58\ud558\uc9c0 \uc548\uc2b5\ub2c8\ub2e4.");
        }
    }
}

