/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.securedobject.impl;

import egovframework.rte.fdl.security.securedobject.EgovSecuredObjectService;
import egovframework.rte.fdl.security.securedobject.impl.SecuredObjectDAO;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.security.ConfigAttributeDefinition;

public class SecuredObjectServiceImpl
implements EgovSecuredObjectService,
ApplicationContextAware,
InitializingBean {
    private MessageSource messageSource;
    private SecuredObjectDAO securedObjectDAO;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setSecuredObjectDAO(SecuredObjectDAO securedObjectDAO) {
        this.securedObjectDAO = securedObjectDAO;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public LinkedHashMap getRolesAndUrl() throws Exception {
        try {
            return this.securedObjectDAO.getRolesAndUrl();
        }
        catch (Exception e) {
            EgovSecuredObjectService.LOGGER.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"Roles and Url"}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }

    public LinkedHashMap getRolesAndMethod() throws Exception {
        try {
            return this.securedObjectDAO.getRolesAndMethod();
        }
        catch (Exception e) {
            EgovSecuredObjectService.LOGGER.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"Roles and Method"}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }

    public LinkedHashMap getRolesAndPointcut() throws Exception {
        try {
            return this.securedObjectDAO.getRolesAndPointcut();
        }
        catch (Exception e) {
            EgovSecuredObjectService.LOGGER.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"Roles and Pointcut"}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }

    public ConfigAttributeDefinition getMatchedRequestMapping(String url) throws Exception {
        try {
            return this.securedObjectDAO.getRegexMatchedRequestMapping(url);
        }
        catch (Exception e) {
            EgovSecuredObjectService.LOGGER.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"MatchedRequestMapping : " + url}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }

    public String getHierarchicalRoles() throws Exception {
        try {
            return this.securedObjectDAO.getHierarchicalRoles();
        }
        catch (Exception e) {
            EgovSecuredObjectService.LOGGER.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"Hierarchical Roles"}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }
}

