/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABPooledConnection;
import Altibase.jdbc.driver.DataSource;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.aStack;
import Altibase.jdbc.driver.ex;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class ABConnectionPoolDataSource
extends DataSource
implements Runnable,
Serializable,
ConnectionPoolDataSource {
    static int mTimeStamp = Integer.MAX_VALUE;
    static final long serialVersionUID = 1L;
    private transient ABConnection con;
    private ConnectionEventListener connectionEventListener = new ABConnectionEventListener();
    private int initialPoolSize = 1;
    private int maxPoolSize = 10;
    private int maxStatements = 0;
    private int mCurrentServer = 0;
    private int mFailCount = 0;
    private int minPoolSize = 0;
    private String[] mURL = null;
    protected aStack available = new aStack();
    protected boolean initialized = false;
    protected Object lock = new LockObject();
    protected int maxIdleTime = 0;
    protected int propertyCycle = 0;
    protected aStack used = new aStack();

    static int getTimeStamp() {
        return mTimeStamp;
    }

    public ABConnectionPoolDataSource() {
        this.prop.setProperty("description", "ConnectionPool Altibase DataSource");
    }

    public ABConnectionPoolDataSource(String[] aURL) {
        this();
        this.mURL = aURL;
        this.setUrl(this.mURL[0]);
        ++this.mCurrentServer;
    }

    public synchronized void close() {
        PooledConnection pci;
        if (this.available == null) {
            return;
        }
        while (this.available.size() > 0) {
            pci = (PooledConnection)this.available.pop();
            try {
                pci.close();
            }
            catch (SQLException e) {}
        }
        this.available = null;
        while (this.used.size() > 0) {
            pci = (PooledConnection)this.used.pop();
            pci.removeConnectionEventListener(this.connectionEventListener);
            try {
                pci.close();
            }
            catch (SQLException sQLException) {}
        }
        this.used = null;
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection sConn;
        block7: {
            sConn = null;
            try {
                if (!this.initialized) {
                    this.initialize();
                }
                sConn = this.getPooledConnection().getConnection();
                this.mFailCount = 0;
            }
            catch (Exception e) {
                ++this.mFailCount;
                if (this.mURL == null) break block7;
                if (this.mFailCount >= this.mURL.length) {
                    e.printStackTrace();
                    System.exit(0);
                }
                this.close();
                this.available = new aStack();
                this.used = new aStack();
                this.initialized = false;
                if (this.mCurrentServer > this.mURL.length - 1) {
                    this.mCurrentServer = 0;
                }
                this.setUrl(this.mURL[this.mCurrentServer]);
                ++this.mCurrentServer;
                try {
                    sConn = this.getPooledConnection().getConnection();
                    this.mFailCount = 0;
                }
                catch (Exception ex2) {
                    ++this.mFailCount;
                }
            }
        }
        return sConn;
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (user == null || user.equals(this.getUser()) && (password == null && this.getPassword() == null || password != null && password.equals(this.getPassword()))) {
            return this.getConnection();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return this.getPooledConnection(user, password).getConnection();
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getOperationTimeout() {
        return this.getMaxIdleTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        pc = null;
        if (!this.initialized) {
            this.initialize();
        }
        ex.test(this.available == null, (short)26, SQLStates.mFixmsg[9]);
        var3_2 = this.lock;
        synchronized (var3_2) {
            block5: while (true) {
                if (!this.available.isEmpty()) {
                    pc = (PooledConnection)this.available.pop();
                    this.used.push(pc);
                    pc.addConnectionEventListener(this.connectionEventListener);
                    break;
                }
                if (this.maxPoolSize == 0 || this.used.size() < this.maxPoolSize) {
                    pc = new ABPooledConnection(this.prop);
                    this.used.push(pc);
                    pc.addConnectionEventListener(this.connectionEventListener);
                    break;
                }
                try {
                    this.lock.wait(this.propertyCycle * 1000);
                    ABConnectionPoolDataSource.mTimeStamp = (int)(System.currentTimeMillis() / 1000L + 1L);
                }
                catch (InterruptedException e) {
                    ex.exception((short)23, SQLStates.mFixmsg[10]);
                }
                if (this.maxIdleTime <= 0 || !this.available.isEmpty()) continue;
                i = this.used.size() - 1;
                while (true) {
                    if (i >= 0) ** break;
                    continue block5;
                    pc = (PooledConnection)this.used.get(i);
                    sIdleTime = ABConnectionPoolDataSource.getTimeStamp() - ((ABPooledConnection)pc).getTimeStamp();
                    if (sIdleTime >= this.maxIdleTime) {
                        ((ABPooledConnection)pc).fireConnectionClosed();
                        if (this.logger != null) {
                            this.logger.println("ABConnectionPoolDataSource(" + pc.hashCode() + ") IdleTimeOut exceed:" + sIdleTime);
                            this.logger.flush();
                        }
                    }
                    --i;
                }
                break;
            }
        }
        return pc;
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        ABPooledConnection pc = (ABPooledConnection)this.getPooledConnection();
        this.con = pc.con;
        if (!this.con.getUser().equalsIgnoreCase(user)) {
            this.con.setConnect(user, password);
        }
        return pc;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public Reference getReference() throws NamingException {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("dataSourceName", this.prop.getProperty("dataSourceName", this.dataSourceName)));
        ref.add(new StringRefAddr("initialPoolSize", this.prop.getProperty("initialPoolSize", String.valueOf(this.initialPoolSize))));
        ref.add(new StringRefAddr("maxPoolSize", this.prop.getProperty("maxPoolSize", String.valueOf(this.maxPoolSize))));
        ref.add(new StringRefAddr("minPoolSize", this.prop.getProperty("minPoolSize", String.valueOf(this.minPoolSize))));
        ref.add(new StringRefAddr("description", this.prop.getProperty("description", "ConnectionPoolDataSource Altibase DataSource")));
        ref.add(new StringRefAddr("maxIdleTime", this.prop.getProperty("maxIdleTime", String.valueOf(this.maxIdleTime))));
        ref.add(new StringRefAddr("propertyCycle", this.prop.getProperty("propertyCycle", String.valueOf(this.propertyCycle))));
        return ref;
    }

    public int getResizingPeriod() {
        return this.getPropertyCycle();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        this.resetPool(this.initialPoolSize);
        this.initialized = true;
    }

    public void run() {
        do {
            block6: {
                try {
                    Thread.sleep(this.propertyCycle);
                    for (int i = 0; i < this.used.size(); ++i) {
                        ABPooledConnection pc = (ABPooledConnection)this.used.get(i);
                        if (pc.getTimeStamp() < this.maxIdleTime) continue;
                        pc.fireConnectionClosed();
                        if (this.logger == null) continue;
                        this.logger.println("PoolManager IdleTimeOut exceed:" + pc.getTimeStamp());
                    }
                }
                catch (InterruptedException e) {
                    if (this.logger != null) {
                        this.logger.println(SQLStates.mFixmsg[11]);
                    }
                }
                catch (SQLException sex) {
                    if (this.logger == null) break block6;
                    this.logger.println(SQLStates.mFixmsg[12] + sex.getMessage());
                }
            }
            this.logger.flush();
        } while (this.available != null);
        this.logger.flush();
    }

    public void setDatabaseName(String databaseName) {
        if (this.initialized) {
            throw new IllegalStateException(SQLStates.mFixmsg[13]);
        }
        super.setDatabaseName(databaseName);
    }

    public void setInitialPoolSize(int poolSize) throws SQLException {
        if (this.initialized) {
            this.resetPool(poolSize);
        } else {
            this.initialPoolSize = poolSize;
        }
        this.prop.setProperty("initialPoolSize", String.valueOf(this.initialPoolSize));
    }

    public void setMaxIdleTime(int v) {
        this.maxIdleTime = v;
        this.prop.setProperty("maxIdleTime", String.valueOf(v));
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.prop.setProperty("maxPoolSize", String.valueOf(maxPoolSize));
    }

    public void setMinPoolSize(int minPoolSize) throws SQLException {
        this.minPoolSize = minPoolSize;
        if (this.initialized) {
            this.resetPool(minPoolSize);
        }
        this.prop.setProperty("minPoolSize", String.valueOf(minPoolSize));
    }

    public void setOperationTimeout(int v) {
        this.setMaxIdleTime(v);
    }

    public void setPassword(String password) {
        if (this.initialized) {
            throw new IllegalStateException(SQLStates.mFixmsg[13]);
        }
        super.setPassword(password);
    }

    public void setPropertyCycle(int v) {
        this.propertyCycle = v;
        this.prop.setProperty("propertyCycle", String.valueOf(v));
    }

    public void setResizingPeriod(int v) {
        this.setPropertyCycle(v);
    }

    public void setServerName(String serverName) {
        if (this.initialized) {
            throw new IllegalStateException(SQLStates.mFixmsg[13]);
        }
        super.setServerName(serverName);
    }

    public void setUser(String user) {
        if (this.initialized) {
            throw new IllegalStateException(SQLStates.mFixmsg[13]);
        }
        super.setUser(user);
    }

    private synchronized void resetPool(int size) throws SQLException {
        this.initialPoolSize = this.minPoolSize > size ? this.minPoolSize : size;
        for (int i = this.available.size() + this.used.size(); i < this.initialPoolSize; ++i) {
            this.available.push(new ABPooledConnection(this.prop));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    private final class LockObject
    implements Serializable {
        static final long serialVersionUID = 111111111L;

        private LockObject() {
        }
    }

    public class ABConnectionEventListener
    implements ConnectionEventListener,
    Serializable {
        static final long serialVersionUID = 3L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void connectionClosed(ConnectionEvent event) {
            boolean removed = false;
            ABPooledConnection pc = (ABPooledConnection)event.getSource();
            if (ABConnectionPoolDataSource.this.available == null) {
                return;
            }
            Object object = ABConnectionPoolDataSource.this.lock;
            synchronized (object) {
                removed = ABConnectionPoolDataSource.this.used.remove(pc);
                if (removed) {
                    if (pc.con == null) {
                        try {
                            ABConnectionPoolDataSource.this.available.notify();
                        }
                        catch (IllegalMonitorStateException e) {
                            // empty catch block
                        }
                        return;
                    }
                    if (ABConnectionPoolDataSource.this.available.size() + ABConnectionPoolDataSource.this.used.size() >= ABConnectionPoolDataSource.this.minPoolSize - 1 && ABConnectionPoolDataSource.this.available.size() < ABConnectionPoolDataSource.this.minPoolSize) {
                        ABConnectionPoolDataSource.this.available.push(pc);
                    } else {
                        try {
                            pc.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    try {
                        ABConnectionPoolDataSource.this.lock.notify();
                    }
                    catch (IllegalMonitorStateException e) {}
                } else if (ABConnectionPoolDataSource.this.logger != null) {
                    ABConnectionPoolDataSource.this.logger.println(SQLStates.mFixmsg[7]);
                }
            }
        }

        public void connectionErrorOccurred(ConnectionEvent event) {
            PooledConnection pcon = (PooledConnection)event.getSource();
            pcon.removeConnectionEventListener(this);
            if (ABConnectionPoolDataSource.this.available == null) {
                return;
            }
            ABConnectionPoolDataSource.this.used.remove(pcon);
            if (ABConnectionPoolDataSource.this.logger != null) {
                ABConnectionPoolDataSource.this.logger.println(SQLStates.mFixmsg[8] + event.getSQLException().getMessage());
                ABConnectionPoolDataSource.this.logger.flush();
            }
            try {
                ABConnectionPoolDataSource.this.available.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }
}

